/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.util;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.util.Clocks;
import com.apple.foundationdb.relational.util.Sampler;
import com.apple.foundationdb.relational.util.TokenBucketSampler;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;

@API(value=API.Status.EXPERIMENTAL)
public class DistinctSampler<K>
implements Predicate<K> {
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private final LoadingCache<K, Sampler> cache;

    public DistinctSampler(int maxSize, int maxLogsPerSecond) {
        this(maxSize, () -> new TokenBucketSampler(maxLogsPerSecond, NANOS_PER_SECOND, Clocks.systemClock()));
    }

    public DistinctSampler(int maxCacheSize, Supplier<Sampler> samplerFactory) {
        this.cache = Caffeine.newBuilder().maximumSize(maxCacheSize).build(item -> (Sampler)samplerFactory.get());
    }

    @Override
    public boolean test(K item) {
        return this.cache.get(item).canSample();
    }
}

