/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.util;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.google.protobuf.Descriptors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class NullableArrayUtils {
    public static final String REPEATED_FIELD_NAME = "values";

    private NullableArrayUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String getRepeatedFieldName() {
        return REPEATED_FIELD_NAME;
    }

    public static boolean isWrappedArrayDescriptor(String fieldName, Descriptors.Descriptor parentDescriptor) {
        try {
            Descriptors.Descriptor childDescriptor = parentDescriptor.findFieldByName(fieldName).getMessageType();
            return NullableArrayUtils.isWrappedArrayDescriptor(childDescriptor);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isWrappedArrayDescriptor(@Nonnull Descriptors.Descriptor descriptor) {
        return descriptor.getFields().size() == 1 && REPEATED_FIELD_NAME.equals(descriptor.getFields().get(0).getName()) && descriptor.findFieldByName(REPEATED_FIELD_NAME).isRepeated();
    }

    public static RecordKeyExpressionProto.KeyExpression wrapArray(RecordKeyExpressionProto.KeyExpression keyExpression, Type.Record record, boolean containsNullableArray) {
        if (!containsNullableArray) {
            return keyExpression;
        }
        TypeRepository.Builder typeRepositoryBuilder = TypeRepository.newBuilder();
        record.defineProtoType(typeRepositoryBuilder);
        Descriptors.Descriptor parentDescriptor = typeRepositoryBuilder.build().getMessageDescriptor(record);
        return NullableArrayUtils.wrapArray(keyExpression, parentDescriptor, containsNullableArray);
    }

    public static RecordKeyExpressionProto.KeyExpression wrapArray(RecordKeyExpressionProto.KeyExpression keyExpression, Descriptors.Descriptor parentDescriptor, boolean containsNullableArray) {
        if (!containsNullableArray) {
            return keyExpression;
        }
        return NullableArrayUtils.wrapArrayInternal(keyExpression, parentDescriptor);
    }

    private static RecordKeyExpressionProto.KeyExpression wrapArrayInternal(RecordKeyExpressionProto.KeyExpression keyExpression, Descriptors.Descriptor parentDescriptor) {
        if (keyExpression.hasThen()) {
            RecordKeyExpressionProto.Then.Builder newThenBuilder = RecordKeyExpressionProto.Then.newBuilder();
            for (RecordKeyExpressionProto.KeyExpression child : keyExpression.getThen().getChildList()) {
                newThenBuilder.addChild(NullableArrayUtils.wrapArrayInternal(child, parentDescriptor));
            }
            return RecordKeyExpressionProto.KeyExpression.newBuilder().setThen(newThenBuilder).build();
        }
        if (keyExpression.hasNesting()) {
            RecordKeyExpressionProto.Field parent = keyExpression.getNesting().getParent();
            String parentFieldName = parent.getFieldName();
            RecordKeyExpressionProto.KeyExpression child = keyExpression.getNesting().getChild();
            if (NullableArrayUtils.isWrappedArrayDescriptor(parentFieldName, parentDescriptor)) {
                RecordKeyExpressionProto.Nesting wrappedParent = NullableArrayUtils.splitFieldIntoNestedWithValues(parent);
                RecordKeyExpressionProto.KeyExpression wrappedChild = NullableArrayUtils.wrapArrayInternal(child, parentDescriptor.findFieldByName(parentFieldName).getMessageType().findFieldByName(REPEATED_FIELD_NAME).getMessageType());
                RecordKeyExpressionProto.KeyExpression newChild = RecordKeyExpressionProto.KeyExpression.newBuilder().setNesting(RecordKeyExpressionProto.Nesting.newBuilder().setParent(wrappedParent.getChild().getField()).setChild(wrappedChild)).build();
                return RecordKeyExpressionProto.KeyExpression.newBuilder().setNesting(RecordKeyExpressionProto.Nesting.newBuilder().setParent(wrappedParent.getParent()).setChild(newChild)).build();
            }
            RecordKeyExpressionProto.KeyExpression wrappedChild = NullableArrayUtils.wrapArrayInternal(child, parentDescriptor.findFieldByName(parentFieldName).getMessageType());
            return RecordKeyExpressionProto.KeyExpression.newBuilder().setNesting(RecordKeyExpressionProto.Nesting.newBuilder().setParent(parent).setChild(wrappedChild)).build();
        }
        if (keyExpression.hasField()) {
            if (NullableArrayUtils.isWrappedArrayDescriptor(keyExpression.getField().getFieldName(), parentDescriptor)) {
                return RecordKeyExpressionProto.KeyExpression.newBuilder().setNesting(NullableArrayUtils.splitFieldIntoNestedWithValues(keyExpression.getField())).build();
            }
            return keyExpression;
        }
        if (keyExpression.hasGrouping()) {
            RecordKeyExpressionProto.KeyExpression newWholeKey = NullableArrayUtils.wrapArrayInternal(keyExpression.getGrouping().getWholeKey(), parentDescriptor);
            return RecordKeyExpressionProto.KeyExpression.newBuilder().setGrouping(keyExpression.getGrouping().toBuilder().setWholeKey(newWholeKey)).build();
        }
        if (keyExpression.hasSplit()) {
            RecordKeyExpressionProto.KeyExpression newJoined = NullableArrayUtils.wrapArrayInternal(keyExpression.getSplit().getJoined(), parentDescriptor);
            return RecordKeyExpressionProto.KeyExpression.newBuilder().setSplit(keyExpression.getSplit().toBuilder().setJoined(newJoined)).build();
        }
        if (keyExpression.hasFunction()) {
            RecordKeyExpressionProto.KeyExpression newArguments = NullableArrayUtils.wrapArrayInternal(keyExpression.getFunction().getArguments(), parentDescriptor);
            return RecordKeyExpressionProto.KeyExpression.newBuilder().setFunction(keyExpression.getFunction().toBuilder().setArguments(newArguments)).build();
        }
        if (keyExpression.hasKeyWithValue()) {
            RecordKeyExpressionProto.KeyExpression newInnerKey = NullableArrayUtils.wrapArrayInternal(keyExpression.getKeyWithValue().getInnerKey(), parentDescriptor);
            return RecordKeyExpressionProto.KeyExpression.newBuilder().setKeyWithValue(keyExpression.getKeyWithValue().toBuilder().setInnerKey(newInnerKey)).build();
        }
        if (keyExpression.hasList()) {
            RecordKeyExpressionProto.List.Builder newListBuilder = RecordKeyExpressionProto.List.newBuilder();
            for (RecordKeyExpressionProto.KeyExpression listItem : keyExpression.getList().getChildList()) {
                newListBuilder.addChild(NullableArrayUtils.wrapArrayInternal(listItem, parentDescriptor));
            }
            return RecordKeyExpressionProto.KeyExpression.newBuilder().setList(newListBuilder).build();
        }
        return keyExpression;
    }

    private static RecordKeyExpressionProto.Nesting splitFieldIntoNestedWithValues(@Nonnull RecordKeyExpressionProto.Field original) {
        RecordKeyExpressionProto.Field.Builder nestedArrayBuilder = RecordKeyExpressionProto.Field.newBuilder().setFieldName(original.getFieldName()).setFanType(RecordKeyExpressionProto.Field.FanType.SCALAR).setNullInterpretation(original.getNullInterpretation());
        RecordKeyExpressionProto.KeyExpression.Builder arrayValueBuilder = RecordKeyExpressionProto.KeyExpression.newBuilder().setField(RecordKeyExpressionProto.Field.newBuilder().setFieldName(REPEATED_FIELD_NAME).setFanType(original.getFanType()).setNullInterpretation(original.getNullInterpretation()));
        return RecordKeyExpressionProto.Nesting.newBuilder().setParent(nestedArrayBuilder).setChild(arrayValueBuilder).build();
    }
}

