/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.util;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.query.OptionsUtils;
import com.apple.foundationdb.relational.recordlayer.query.Plan;
import com.apple.foundationdb.relational.recordlayer.query.QueryPlan;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

@API(value=API.Status.EXPERIMENTAL)
public class RelationalLoggingUtil {
    public static void publishPlanGenerationLogs(Logger logger, KeyValueLogMessage message, @Nullable Plan<?> plan, @Nullable RelationalException e, long totalTime, Options options) {
        boolean logQuery = (Boolean)options.getOption(Options.Name.LOG_QUERY);
        boolean isSlow = totalTime > (Long)options.getOption(Options.Name.LOG_SLOW_QUERY_THRESHOLD_MICROS);
        message.addKeyAndValue("totalPlanTimeMicros", totalTime);
        if (plan != null) {
            if (plan instanceof QueryPlan.PhysicalQueryPlan) {
                int planHash = ((QueryPlan.PhysicalQueryPlan)plan).planHash(OptionsUtils.getCurrentPlanHashMode(options));
                message.addKeyAndValue("planHash", planHash);
            }
            message.addKeyAndValue("plan", plan.explain());
        }
        if (e != null) {
            logger.error(message, (Throwable)e);
        } else if (logQuery || isSlow) {
            logger.info(message);
        } else if (logger.isDebugEnabled()) {
            logger.debug(message);
        }
    }

    public static void publishNormalizeQueryLogs(KeyValueLogMessage message, long stepTime, int queryHash, String query) {
        message.addKeyAndValue("queryHash", queryHash);
        message.addKeyAndValue("query", query.trim());
        message.addKeyAndValue("normalizeQueryTimeMicros", stepTime);
    }

    public static void publishPlanCacheLogs(KeyValueLogMessage message, PlanCacheEvent event, long stepTime, long primaryCacheNumEntries) {
        switch (event) {
            case SKIP: {
                message.addKeyAndValue("planCache", "skip");
                message.addKeyAndValue("generatePhysicalPlanTimeMicros", stepTime);
                break;
            }
            case HIT: {
                message.addKeyAndValue("planCache", "hit");
                message.addKeyAndValue("primaryCacheNumEntries", primaryCacheNumEntries);
                break;
            }
            case MISS: {
                message.addKeyAndValue("planCache", "miss");
                message.addKeyAndValue("generatePhysicalPlanTimeMicros", stepTime);
                message.addKeyAndValue("primaryCacheNumEntries", primaryCacheNumEntries);
                break;
            }
        }
    }

    public static enum PlanCacheEvent {
        SKIP,
        HIT,
        MISS;

    }
}

