/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.util;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.util.Clocks;
import com.apple.foundationdb.relational.util.EventSampler;
import com.apple.foundationdb.relational.util.Sampler;
import com.apple.foundationdb.relational.util.TokenBucketSampler;
import java.util.concurrent.TimeUnit;

@API(value=API.Status.EXPERIMENTAL)
public final class Sampling {
    private Sampling() {
    }

    public static Sampler newSampler(int maxSamplesPerUnit, TimeUnit timeUnit) {
        long refreshInterval = timeUnit.toNanos(1L) / (long)maxSamplesPerUnit;
        return new TokenBucketSampler(maxSamplesPerUnit, refreshInterval, Clocks.systemClock());
    }

    public static Sampler eventSampler(int maxSamplesPerEvent, long eventRefreshInterval) {
        return new EventSampler(maxSamplesPerEvent, eventRefreshInterval);
    }
}

