/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.util;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.Clock;
import com.apple.foundationdb.relational.util.Sampler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@API(value=API.Status.EXPERIMENTAL)
public class TokenBucketSampler
implements Sampler {
    private final int maxTokens;
    private final long refreshIntervalNanos;
    private final Clock clock;
    private final AtomicLong numTokens;
    private final AtomicLong lastRefreshTime;

    public TokenBucketSampler(int maxTokens, long refreshInterval, TimeUnit refreshTime, Clock clock) {
        this(maxTokens, refreshTime.toNanos(refreshInterval), clock);
    }

    public TokenBucketSampler(int maxTokens, long refreshIntervalNanos, Clock clock) {
        Assert.thatUnchecked(maxTokens > 0);
        Assert.thatUnchecked(refreshIntervalNanos > 0L);
        this.maxTokens = maxTokens;
        this.refreshIntervalNanos = refreshIntervalNanos;
        this.clock = clock;
        this.numTokens = new AtomicLong(maxTokens);
        this.lastRefreshTime = new AtomicLong(clock.readNanos());
    }

    @Override
    public boolean canSample() {
        long tokensRemaining;
        boolean shouldContinue;
        this.refreshTokens();
        do {
            if ((tokensRemaining = this.numTokens.get()) != 0L) continue;
            return false;
        } while (shouldContinue = !this.numTokens.compareAndSet(tokensRemaining, tokensRemaining - 1L));
        return true;
    }

    private void refreshTokens() {
        long lastTime;
        long currTime = this.clock.readNanos();
        if (currTime - (lastTime = this.lastRefreshTime.get()) >= this.refreshIntervalNanos && this.lastRefreshTime.compareAndSet(lastTime, currTime)) {
            long totalTokens;
            long currTokens;
            boolean shouldContinue;
            long tokensToAdd = (currTime - lastTime) / this.refreshIntervalNanos;
            do {
                if ((totalTokens = tokensToAdd + (currTokens = this.numTokens.get())) <= (long)this.maxTokens) continue;
                totalTokens = this.maxTokens;
            } while (shouldContinue = !this.numTokens.compareAndSet(currTokens, totalTokens));
        }
    }
}

