/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.synchronizedsession;

import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.synchronizedsession.SynchronizedSessionLockedException;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.util.LogMessageKeys;
import com.apple.foundationdb.util.LoggableException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class SynchronizedSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizedSession.class);
    @Nonnull
    private Subspace lockSubspace;
    @Nonnull
    private UUID sessionId;
    private long leaseLengthMillis;
    @Nonnull
    private final byte[] lockSessionIdSubspaceKey;
    @Nonnull
    private final byte[] lockSessionLeaseEndTimeSubspaceKey;
    private static final Object LOCK_SESSION_ID_KEY = 0L;
    private static final Object LOCK_SESSION_TIME_KEY = 1L;

    public SynchronizedSession(@Nonnull Subspace lockSubspace, @Nonnull UUID sessionId, long leaseLengthMillis) {
        this.lockSubspace = lockSubspace;
        this.sessionId = sessionId;
        this.leaseLengthMillis = leaseLengthMillis;
        this.lockSessionIdSubspaceKey = SynchronizedSession.lockSessionIdSubspaceKey(lockSubspace);
        this.lockSessionLeaseEndTimeSubspaceKey = SynchronizedSession.lockSessionLeaseEndTimeSubspaceKey(lockSubspace);
    }

    private static byte[] lockSessionIdSubspaceKey(@Nonnull Subspace lockSubspace) {
        return lockSubspace.subspace(Tuple.from(LOCK_SESSION_ID_KEY)).pack();
    }

    private static byte[] lockSessionLeaseEndTimeSubspaceKey(@Nonnull Subspace lockSubspace) {
        return lockSubspace.subspace(Tuple.from(LOCK_SESSION_TIME_KEY)).pack();
    }

    public CompletableFuture<Void> initializeSessionAsync(@Nonnull Transaction tr) {
        return this.getLockSessionId(tr).thenAcceptBoth(this.getLockSessionTime(tr.snapshot()), (lockSessionId, sessionTime) -> {
            if (lockSessionId == null) {
                this.takeSessionLock(tr);
            } else {
                if (lockSessionId.equals(this.sessionId)) {
                    throw new LoggableException("session id already exists in subspace").addLogInfo(new Object[]{LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(this.lockSubspace.getKey())}).addLogInfo(new Object[]{LogMessageKeys.SESSION_ID, this.sessionId});
                }
                if (sessionTime == null) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Session ID is set but session time is not {}={} {}={}", new Object[]{LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(this.lockSubspace.getKey()), LogMessageKeys.SESSION_ID, this.sessionId});
                    }
                    this.takeSessionLock(tr);
                } else if (sessionTime < System.currentTimeMillis()) {
                    this.takeSessionLock(tr);
                } else {
                    throw new SynchronizedSessionLockedException("Failed to initialize the session because of an existing session in progress", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(this.lockSubspace.getKey())}).addLogInfo(new Object[]{LogMessageKeys.SESSION_ID, this.sessionId}).addLogInfo(new Object[]{LogMessageKeys.EXISTING_SESSION, lockSessionId}).addLogInfo(new Object[]{LogMessageKeys.EXISTING_SESSION_EXPIRE_TIME, sessionTime});
                }
            }
        });
    }

    private void takeSessionLock(@Nonnull Transaction tr) {
        this.setLockSessionId(tr);
        this.updateLockSessionLeaseEndTime(tr);
    }

    @Nonnull
    public UUID getSessionId() {
        return this.sessionId;
    }

    public CompletableFuture<Void> checkLockAsync(@Nonnull Transaction tr) {
        return this.getLockSessionId(tr).thenCompose(lockSessionId -> {
            if (!this.sessionId.equals(lockSessionId)) {
                throw new SynchronizedSessionLockedException("Failed to continue the session", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(this.lockSubspace.getKey())}).addLogInfo(new Object[]{LogMessageKeys.SESSION_ID, this.sessionId}).addLogInfo(new Object[]{LogMessageKeys.EXISTING_SESSION, lockSessionId});
            }
            return AsyncUtil.DONE;
        });
    }

    public CompletableFuture<Void> releaseLock(@Nonnull Transaction tr) {
        return this.getLockSessionId(tr).thenApply(lockSessionId -> {
            if (this.sessionId.equals(lockSessionId)) {
                tr.clear(this.lockSubspace.range());
            }
            return null;
        });
    }

    public void endAnySession(@Nonnull Transaction tr) {
        SynchronizedSession.endAnySession(tr, this.lockSubspace);
    }

    public static void endAnySession(@Nonnull Transaction tr, @Nonnull Subspace lockSubspace) {
        tr.clear(lockSubspace.range());
    }

    public static CompletableFuture<Boolean> checkActiveSessionExists(@Nonnull Transaction tr, @Nonnull Subspace lockSubspace) {
        return SynchronizedSession.getLockSessionId(tr, lockSubspace).thenCombineAsync(SynchronizedSession.getLockSessionTime(tr.snapshot(), lockSubspace), (lockSessionId, sessionTime) -> {
            if (lockSessionId == null) {
                return false;
            }
            if (sessionTime == null) {
                return false;
            }
            if (sessionTime < System.currentTimeMillis()) {
                return false;
            }
            return true;
        });
    }

    private static CompletableFuture<UUID> getLockSessionId(@Nonnull Transaction tr, @Nonnull Subspace lockSubspace) {
        return tr.get(SynchronizedSession.lockSessionIdSubspaceKey(lockSubspace)).thenApply(value -> value == null ? null : Tuple.fromBytes(value).getUUID(0));
    }

    private CompletableFuture<UUID> getLockSessionId(@Nonnull Transaction tr) {
        return SynchronizedSession.getLockSessionId(tr, this.lockSubspace);
    }

    private void setLockSessionId(@Nonnull Transaction tr) {
        tr.set(this.lockSessionIdSubspaceKey, Tuple.from(this.sessionId).pack());
    }

    private static CompletableFuture<Long> getLockSessionTime(@Nonnull ReadTransaction tr, @Nonnull Subspace lockSubspace) {
        return tr.get(SynchronizedSession.lockSessionLeaseEndTimeSubspaceKey(lockSubspace)).thenApply(value -> value == null ? null : Long.valueOf(Tuple.fromBytes(value).getLong(0)));
    }

    private CompletableFuture<Long> getLockSessionTime(@Nonnull ReadTransaction tr) {
        return SynchronizedSession.getLockSessionTime(tr, this.lockSubspace);
    }

    public void updateLockSessionLeaseEndTime(@Nonnull Transaction tr) {
        long leaseEndTime = System.currentTimeMillis() + this.leaseLengthMillis;
        tr.mutate(MutationType.BYTE_MAX, this.lockSessionLeaseEndTimeSubspaceKey, Tuple.from(leaseEndTime).pack());
    }
}

