/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.system;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

@SpotBugsSuppressWarnings(value={"MS_MUTABLE_ARRAY"}, justification="array copying is expensive")
@API(value=API.Status.INTERNAL)
public class SystemKeyspace {
    private static final byte[] SYSTEM_PREFIX = new byte[]{-1};
    private static final byte[] SYSTEM_2_PREFIX = new byte[]{-1, 2};
    private static final byte[] SPECIAL_PREFIX = new byte[]{-1, -1};
    public static final byte[] METADATA_VERSION_KEY = SystemKeyspace.systemPrefixedKey("/metadataVersion");
    public static final byte[] PRIMARY_DATACENTER_KEY = SystemKeyspace.systemPrefixedKey("/primaryDatacenter");
    public static final byte[] TIMEKEEPER_KEY_PREFIX = SystemKeyspace.system2PrefixedKey("/timeKeeper/map/");
    public static final byte[] CLIENT_LOG_KEY_PREFIX = SystemKeyspace.system2PrefixedKey("/fdbClientInfo/client_latency/");
    public static final byte[] CONNECTION_STR_KEY = SystemKeyspace.specialPrefixedKey("/connection_string");
    public static final byte[] CLUSTER_FILE_PATH_KEY = SystemKeyspace.specialPrefixedKey("/cluster_file_path");
    public static final byte[] TRANSACTION_CONFLICTING_KEYS_PREFIX = SystemKeyspace.specialPrefixedKey("/transaction/conflicting_keys/");

    private static byte[] systemPrefixedKey(@Nonnull String key) {
        return ByteArrayUtil.join(SYSTEM_PREFIX, key.getBytes(StandardCharsets.US_ASCII));
    }

    private static byte[] system2PrefixedKey(@Nonnull String key) {
        return ByteArrayUtil.join(SYSTEM_2_PREFIX, key.getBytes(StandardCharsets.US_ASCII));
    }

    private static byte[] specialPrefixedKey(@Nonnull String key) {
        return ByteArrayUtil.join(SPECIAL_PREFIX, key.getBytes(StandardCharsets.US_ASCII));
    }

    private SystemKeyspace() {
    }
}

