/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.tuple;

import com.apple.foundationdb.annotation.API;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class ByteArrayUtil2 {
    private static final byte EQUALS_CHARACTER = 61;
    private static final byte DOUBLE_QUOTE_CHARACTER = 34;
    private static final byte SINGLE_QUOTE_CHARACTER = 39;
    private static final byte BACKSLASH_CHARACTER = 92;
    private static final byte MINIMUM_PRINTABLE_CHARACTER = 32;
    private static final int MAXIMUM_PRINTABLE_CHARACTER = 127;
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] LOWER_CASE_HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Nullable
    public static String toHexString(@Nullable byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] hex = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hex[j * 2] = HEX_CHARS[v >>> 4];
            hex[j * 2 + 1] = HEX_CHARS[v & 0xF];
        }
        return new String(hex);
    }

    @Nullable
    @API(value=API.Status.UNSTABLE)
    public static String loggable(@Nullable byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            if (b >= 32 && b < 127 && b != 92 && b != 61 && b != 34 && b != 39) {
                sb.append((char)b);
                continue;
            }
            if (b == 92) {
                sb.append("\\\\");
                continue;
            }
            sb.append("\\x").append(LOWER_CASE_HEX_CHARS[b >>> 4 & 0xF]).append(LOWER_CASE_HEX_CHARS[b & 0xF]);
        }
        return sb.toString();
    }

    @Nullable
    @API(value=API.Status.UNSTABLE)
    public static byte[] unprint(@Nullable String loggedBytes) {
        if (loggedBytes == null) {
            return null;
        }
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        for (int i = 0; i < loggedBytes.length(); ++i) {
            char c = loggedBytes.charAt(i);
            if (c == '\\') {
                if ((c = loggedBytes.charAt(++i)) == '\\') {
                    bytes.add((byte)92);
                    continue;
                }
                if (c == 'x') {
                    bytes.add((byte)Integer.parseInt(loggedBytes.substring(++i, i + 2), 16));
                    ++i;
                    continue;
                }
                throw new IllegalArgumentException("unexpected char at " + i);
            }
            bytes.add((byte)c);
        }
        byte[] bytesArray = new byte[bytes.size()];
        for (int j = 0; j < bytes.size(); ++j) {
            bytesArray[j] = (Byte)bytes.get(j);
        }
        return bytesArray;
    }

    public static boolean hasCommonPrefix(@Nonnull byte[] bytes1, @Nonnull byte[] bytes2, int prefixSize) {
        if (bytes1.length < prefixSize || bytes2.length < prefixSize) {
            return false;
        }
        for (int i = 0; i < prefixSize; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }

    private ByteArrayUtil2() {
    }
}

