/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.tuple;

final class StringUtil {
    private static final char SURROGATE_COUNT = '\u0800';
    private static final char ABOVE_SURROGATES = '\u2000';
    private static final String HIGH_WITHOUT_LOW_ERR_MSG = "malformed UTF-16 string contains high surrogate that is not followed by low surrogate";
    private static final String LOW_WITHOUT_HIGH_ERR_MSG = "malformed UTF-16 string contains low surrogate without prior high surrogate";

    static char adjustForSurrogates(char c, String string, int n) {
        if (c > '\udfff') {
            return (char)(c - 2048);
        }
        if (Character.isHighSurrogate(c) && (n + 1 >= string.length() || !Character.isLowSurrogate(string.charAt(n + 1)))) {
            throw new IllegalArgumentException(HIGH_WITHOUT_LOW_ERR_MSG);
        }
        if (Character.isLowSurrogate(c) && (n == 0 || !Character.isHighSurrogate(string.charAt(n - 1)))) {
            throw new IllegalArgumentException(LOW_WITHOUT_HIGH_ERR_MSG);
        }
        return (char)(c + 8192);
    }

    static void validate(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (Character.isHighSurrogate(c)) {
                if (n2 + 1 >= n || !Character.isLowSurrogate(string.charAt(n2 + 1))) {
                    throw new IllegalArgumentException(HIGH_WITHOUT_LOW_ERR_MSG);
                }
                n2 += 2;
                continue;
            }
            if (Character.isLowSurrogate(c)) {
                throw new IllegalArgumentException(LOW_WITHOUT_HIGH_ERR_MSG);
            }
            ++n2;
        }
    }

    static int compareUtf8(String string, String string2) {
        int n;
        int n2 = string.length();
        int n3 = string2.length();
        for (n = 0; n < n2 && n < n3 && string.charAt(n) == string2.charAt(n); ++n) {
        }
        if (n >= n2 || n >= n3) {
            return Integer.compare(n2, n3);
        }
        char c = string.charAt(n);
        char c2 = string2.charAt(n);
        if (c >= '\ud800') {
            c = StringUtil.adjustForSurrogates(c, string, n);
        }
        if (c2 >= '\ud800') {
            c2 = StringUtil.adjustForSurrogates(c2, string2, n);
        }
        return Character.compare(c, c2);
    }

    static int packedSize(String string) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\u0000') {
                n2 += 2;
                continue;
            }
            if (c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c <= '\u07ff') {
                n2 += 2;
                continue;
            }
            if (Character.isHighSurrogate(c)) {
                if (i + 1 < string.length() && Character.isLowSurrogate(string.charAt(i + 1))) {
                    n2 += 4;
                    ++i;
                    continue;
                }
                throw new IllegalArgumentException(HIGH_WITHOUT_LOW_ERR_MSG);
            }
            if (Character.isLowSurrogate(c)) {
                throw new IllegalArgumentException(LOW_WITHOUT_HIGH_ERR_MSG);
            }
            n2 += 3;
        }
        return n2;
    }

    private StringUtil() {
    }
}

