/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.tuple;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class TupleOrdering {
    static final byte NULL_LAST = -2;

    private TupleOrdering() {
    }

    @Nonnull
    public static byte[] pack(@Nonnull Tuple tuple, @Nonnull Direction direction) {
        byte[] packed = direction.isCounterflowNulls() ? TupleOrdering.packNullsLast(tuple.elements) : tuple.pack();
        return direction.isInverted() ? TupleOrdering.invert(packed) : packed;
    }

    @Nonnull
    public static Tuple unpack(@Nonnull byte[] packed, @Nonnull Direction direction) {
        byte[] bytes = direction.isInverted() ? TupleOrdering.uninvert(packed) : packed;
        return direction.isCounterflowNulls() ? Tuple.fromList(TupleOrdering.unpackNullsLast(bytes)) : Tuple.fromBytes(bytes);
    }

    @Nonnull
    static byte[] packNullsLast(@Nonnull List<Object> elements) {
        ByteBuffer dest = ByteBuffer.allocate(TupleUtil.getPackedSize(elements, false));
        ByteOrder origOrder = dest.order();
        TupleUtil.EncodeState state = new TupleUtil.EncodeState(dest);
        for (Object obj : elements) {
            TupleOrdering.encodeNullsLast(state, obj);
        }
        dest.order(origOrder);
        if (state.versionPos >= 0) {
            throw new IllegalArgumentException("Incomplete Versionstamp included in vanilla tuple pack");
        }
        return dest.array();
    }

    static void encodeNullsLast(@Nonnull TupleUtil.EncodeState state, @Nullable Object obj) {
        if (obj == null) {
            state.add((byte)-2);
        } else {
            TupleUtil.encode(state, obj, false);
        }
    }

    @Nonnull
    static List<Object> unpackNullsLast(@Nonnull byte[] bytes) {
        TupleUtil.DecodeState decodeState = new TupleUtil.DecodeState();
        int pos = 0;
        int end = bytes.length;
        while (pos < end) {
            TupleOrdering.decodeNullsLast(decodeState, bytes, pos, end);
            pos = decodeState.end;
        }
        return decodeState.values;
    }

    static void decodeNullsLast(@Nonnull TupleUtil.DecodeState state, @Nonnull byte[] bytes, int pos, int end) {
        if (bytes[pos] == -2) {
            state.add(null, pos + 1);
        } else {
            TupleUtil.decode(state, bytes, pos, end);
        }
    }

    @Nonnull
    static byte[] invert(@Nonnull byte[] bytes) {
        int originalLength = bytes.length;
        int invertedLength = (originalLength * 8 + 6) / 7 + 1;
        byte[] inverted = new byte[invertedLength];
        int bits = 0;
        int nbits = 0;
        int in = 0;
        int out = 0;
        while (in < originalLength) {
            bits = bits << 8 | bytes[in++] & 0xFF ^ 0xFF;
            nbits += 8;
            while (nbits >= 7) {
                inverted[out++] = (byte)(bits >> nbits - 7 & 0x7F);
                nbits -= 7;
            }
        }
        if (nbits == 0) {
            inverted[out++] = -128;
        } else {
            int npad = 7 - nbits;
            inverted[out++] = (byte)((bits << npad | (1 << npad) - 1) & 0x7F);
            inverted[out++] = (byte)(0x80 | npad << 4);
        }
        if (out != invertedLength) {
            throw new IllegalStateException("ordering invert did not encode to correct number of bytes");
        }
        return inverted;
    }

    @Nonnull
    static byte[] uninvert(@Nonnull byte[] inverted) {
        int invertedLength = inverted.length;
        if (invertedLength == 0 || (inverted[invertedLength - 1] & 0x80) == 0) {
            throw new IllegalArgumentException("inverted bytes not in expected format");
        }
        int uninvertedBitLength = (invertedLength - 1) * 7 - ((inverted[invertedLength - 1] & 0x70) >> 4);
        if (uninvertedBitLength % 8 != 0) {
            throw new IllegalStateException("inverted length not even number of bytes");
        }
        int uninvertedLength = uninvertedBitLength / 8;
        byte[] uninverted = new byte[uninvertedLength];
        int bits = 0;
        int nbits = 0;
        int in = 0;
        int out = 0;
        while (in < invertedLength - 1) {
            int next;
            if (((next = inverted[in++] ^ 0x7F) & 0x80) != 0) {
                throw new IllegalArgumentException("non final inverted byte has high bit");
            }
            bits = bits << 7 | next;
            nbits += 7;
            while (nbits >= 8) {
                uninverted[out++] = (byte)(bits >> nbits - 8);
                nbits -= 8;
            }
        }
        if (out != uninvertedLength) {
            throw new IllegalStateException("ordering uninvert did not encode to correct number of bytes");
        }
        return uninverted;
    }

    public static enum Direction {
        ASC_NULLS_FIRST(false, false, "\u2191"),
        ASC_NULLS_LAST(false, true, "\u2197"),
        DESC_NULLS_FIRST(true, true, "\u2199"),
        DESC_NULLS_LAST(true, false, "\u2193");

        private final boolean inverted;
        private final boolean counterflowNulls;
        private final String arrowIndicator;

        private Direction(boolean inverted, boolean counterflowNulls, String arrowIndicator) {
            this.inverted = inverted;
            this.counterflowNulls = counterflowNulls;
            this.arrowIndicator = arrowIndicator;
        }

        public boolean isInverted() {
            return this.inverted;
        }

        public boolean isCounterflowNulls() {
            return this.counterflowNulls;
        }

        public String getArrowIndicator() {
            return this.arrowIndicator;
        }

        public boolean isAscending() {
            return !this.inverted;
        }

        public boolean isDescending() {
            return this.inverted;
        }

        public boolean isNullsFirst() {
            return this.inverted == this.counterflowNulls;
        }

        public boolean isNullsLast() {
            return this.inverted != this.counterflowNulls;
        }

        @Nonnull
        public Direction reverseDirection() {
            switch (this) {
                case ASC_NULLS_FIRST: {
                    return DESC_NULLS_LAST;
                }
                case ASC_NULLS_LAST: {
                    return DESC_NULLS_FIRST;
                }
                case DESC_NULLS_FIRST: {
                    return ASC_NULLS_LAST;
                }
                case DESC_NULLS_LAST: {
                    return ASC_NULLS_FIRST;
                }
            }
            throw new IllegalArgumentException("cannot reverse this direction");
        }
    }
}

