/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.util;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.util.CloseException;

public class CloseableUtils {
    @API(value=API.Status.INTERNAL)
    public static void closeAll(AutoCloseable ... closeables) throws CloseException {
        Throwable accumulatedException = null;
        for (AutoCloseable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (accumulatedException == null) {
                    accumulatedException = new CloseException(e);
                    continue;
                }
                accumulatedException.addSuppressed(e);
            }
            catch (Exception e) {
                if (accumulatedException == null) {
                    accumulatedException = new CloseException(e);
                    continue;
                }
                accumulatedException.addSuppressed(e);
            }
        }
        if (accumulatedException != null) {
            throw accumulatedException;
        }
    }

    private CloseableUtils() {
    }
}

