/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.util;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.util.LoggableKeysAndValues;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class LoggableKeysAndValuesImpl
implements LoggableKeysAndValues<LoggableKeysAndValuesImpl> {
    private static final Object[] EMPTY_LOG_INFO = new Object[0];
    @Nullable
    private Map<String, Object> logInfo;

    public LoggableKeysAndValuesImpl(Object ... keyValues) {
        if (keyValues != null) {
            this.addLogInfo(keyValues);
        }
    }

    @Override
    @Nonnull
    public Map<String, Object> getLogInfo() {
        if (this.logInfo == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.logInfo);
    }

    @Override
    @Nonnull
    public LoggableKeysAndValuesImpl addLogInfo(@Nonnull String description, Object object) {
        if (this.logInfo == null) {
            this.logInfo = new HashMap<String, Object>();
        }
        this.logInfo.put(description, object);
        return this;
    }

    @Override
    @Nonnull
    public LoggableKeysAndValuesImpl addLogInfo(Object ... keyValue) {
        if (keyValue.length % 2 != 0) {
            throw new IllegalArgumentException("Unbalanced key/value logging info");
        }
        for (int i = 0; i < keyValue.length; i += 2) {
            this.addLogInfo(String.valueOf(keyValue[i]), keyValue[i + 1]);
        }
        return this;
    }

    @Override
    @Nonnull
    public Object[] exportLogInfo() {
        if (this.logInfo == null) {
            return EMPTY_LOG_INFO;
        }
        Object[] exportedInfo = new Object[2 * this.logInfo.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : this.logInfo.entrySet()) {
            exportedInfo[i] = entry.getKey();
            exportedInfo[i + 1] = entry.getValue();
            i += 2;
        }
        return exportedInfo;
    }
}

