/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.util;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StringUtils {
    public static boolean isNumeric(@Nonnull String s2) {
        return StringUtils.isNumeric(s2, 0);
    }

    public static boolean isNumeric(@Nonnull String s2, int beginIndex) {
        return StringUtils.isNumeric(s2, beginIndex, s2.length());
    }

    public static boolean isNumeric(@Nonnull String s2, int beginIndex, int endIndex) {
        Preconditions.checkArgument(beginIndex >= 0 && beginIndex <= s2.length(), "beginIndex should be within bounds");
        Preconditions.checkArgument(endIndex >= beginIndex && endIndex <= s2.length(), "endIndex should be within bounds");
        if (beginIndex == endIndex) {
            return false;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            if (Character.isDigit(s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        char[] arr = new char[n];
        Arrays.fill(arr, c);
        return new String(arr);
    }

    @Nonnull
    public static String replaceEach(@Nonnull String source, @Nonnull Map<String, String> replaceMap) {
        if (source.isEmpty() || replaceMap.isEmpty()) {
            return source;
        }
        PriorityQueue<Replacement> replacements = new PriorityQueue<Replacement>(replaceMap.size());
        for (Map.Entry<String, String> replaceEntry : replaceMap.entrySet()) {
            int replacementIndex;
            String replaceString = replaceEntry.getKey();
            if (replaceString.isEmpty() || (replacementIndex = source.indexOf(replaceString)) < 0) continue;
            replacements.add(new Replacement(replacementIndex, replaceString, replaceEntry.getValue()));
        }
        if (replacements.isEmpty()) {
            return source;
        }
        int consumedSoFar = 0;
        StringBuilder builder = new StringBuilder(source.length());
        while (!replacements.isEmpty()) {
            Replacement next;
            Replacement replacement = (Replacement)replacements.poll();
            if (replacement.index >= consumedSoFar) {
                if (replacement.index > consumedSoFar) {
                    builder.append(source, consumedSoFar, replacement.index);
                    consumedSoFar = replacement.index;
                }
                consumedSoFar += replacement.toReplace.length();
                builder.append(replacement.replaceWith);
            }
            if ((next = replacement.nextOccurrence(source)) == null) continue;
            replacements.add(next);
        }
        if (consumedSoFar < source.length()) {
            builder.append(source.substring(consumedSoFar));
        }
        return builder.toString();
    }

    public static boolean containsIgnoreCase(@Nonnull String source, @Nonnull String searchStr) {
        if (source.length() < searchStr.length()) {
            return false;
        }
        if (source.length() == searchStr.length()) {
            return source.equalsIgnoreCase(searchStr);
        }
        for (int i = 0; i <= source.length() - searchStr.length(); ++i) {
            if (!source.regionMatches(true, i, searchStr, 0, searchStr.length())) continue;
            return true;
        }
        return false;
    }

    private static final class Replacement
    implements Comparable<Replacement> {
        private final int index;
        private final String toReplace;
        private final String replaceWith;

        Replacement(int index, String toReplace, String replaceWith) {
            this.index = index;
            this.toReplace = toReplace;
            this.replaceWith = replaceWith;
        }

        @Override
        public int compareTo(Replacement o) {
            int indexComparison = Integer.compare(this.index, o.index);
            if (indexComparison != 0) {
                return indexComparison;
            }
            return -1 * this.toReplace.compareTo(o.toReplace);
        }

        @Nullable
        public Replacement nextOccurrence(@Nonnull String source) {
            int nextIndex = source.indexOf(this.toReplace, this.index + 1);
            return nextIndex < 0 ? null : new Replacement(nextIndex, this.toReplace, this.replaceWith);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Replacement that = (Replacement)o;
            return this.index == that.index && Objects.equals(this.toReplace, that.toReplace) && Objects.equals(this.replaceWith, that.replaceWith);
        }

        public int hashCode() {
            return Objects.hash(this.index, this.toReplace, this.replaceWith);
        }
    }
}

