/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.guava;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingConcurrentMap;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

class CaffeinatedGuavaCache<K, V>
implements Cache<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final com.github.benmanes.caffeine.cache.Cache<K, V> cache;
    private transient @Nullable ConcurrentMap<K, V> mapView;

    CaffeinatedGuavaCache(com.github.benmanes.caffeine.cache.Cache<K, V> cache) {
        this.cache = Objects.requireNonNull(cache);
    }

    @Override
    public @Nullable V getIfPresent(Object key) {
        Object castedKey = key;
        return this.cache.getIfPresent(castedKey);
    }

    @Override
    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        Objects.requireNonNull(valueLoader);
        try {
            return (V)this.cache.get(key, (? super K k) -> {
                try {
                    Object value = valueLoader.call();
                    if (value == null) {
                        throw new CacheLoader.InvalidCacheLoadException("null value");
                    }
                    return value;
                }
                catch (CacheLoader.InvalidCacheLoadException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new UncheckedExecutionException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new CacheLoaderException(e);
                }
                catch (Exception e) {
                    throw new CacheLoaderException(e);
                }
                catch (Error e) {
                    throw new ExecutionError(e);
                }
            });
        }
        catch (CacheLoaderException e) {
            throw new ExecutionException(e.getCause());
        }
    }

    @Override
    public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
        Iterable<?> castedKeys = keys;
        return ImmutableMap.copyOf(this.cache.getAllPresent(castedKeys));
    }

    @Override
    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        this.cache.putAll(m4);
    }

    @Override
    public void invalidate(Object key) {
        Object castedKey = key;
        this.cache.invalidate(castedKey);
    }

    @Override
    public void invalidateAll(Iterable<?> keys) {
        Iterable<?> castedKeys = keys;
        this.cache.invalidateAll(castedKeys);
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public long size() {
        return this.cache.estimatedSize();
    }

    @Override
    public CacheStats stats() {
        com.github.benmanes.caffeine.cache.stats.CacheStats stats = this.cache.stats();
        return new CacheStats(stats.hitCount(), stats.missCount(), stats.loadSuccessCount(), stats.loadFailureCount(), stats.totalLoadTime(), stats.evictionCount());
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        return this.mapView == null ? (this.mapView = new AsMapView()) : this.mapView;
    }

    @Override
    public void cleanUp() {
        this.cache.cleanUp();
    }

    static final class CacheLoaderException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        CacheLoaderException(Exception e) {
            super(e);
        }

        @Override
        @CanIgnoreReturnValue
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    final class EntrySetView
    extends ForwardingSet<Map.Entry<K, V>> {
        EntrySetView() {
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<K, V>> filter) {
            return this.delegate().removeIf(filter);
        }

        @Override
        protected Set<Map.Entry<K, V>> delegate() {
            return CaffeinatedGuavaCache.this.cache.asMap().entrySet();
        }
    }

    final class ValuesView
    extends ForwardingCollection<V> {
        ValuesView() {
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter) {
            return this.delegate().removeIf(filter);
        }

        @Override
        public boolean remove(@Nullable Object o) {
            return o != null && this.delegate().remove(o);
        }

        @Override
        protected Collection<V> delegate() {
            return CaffeinatedGuavaCache.this.cache.asMap().values();
        }
    }

    final class KeySetView
    extends ForwardingSet<K> {
        KeySetView() {
        }

        @Override
        public boolean removeIf(Predicate<? super K> filter) {
            return this.delegate().removeIf(filter);
        }

        @Override
        public boolean remove(Object o) {
            return o != null && this.delegate().remove(o);
        }

        @Override
        protected Set<K> delegate() {
            return CaffeinatedGuavaCache.this.cache.asMap().keySet();
        }
    }

    final class AsMapView
    extends ForwardingConcurrentMap<K, V> {
        @Nullable Set<Map.Entry<K, V>> entrySet;
        @Nullable Collection<V> values;
        @Nullable Set<K> keySet;

        AsMapView() {
        }

        @Override
        public boolean containsKey(@Nullable Object key) {
            return key != null && this.delegate().containsKey(key);
        }

        @Override
        public boolean containsValue(@Nullable Object value) {
            return value != null && this.delegate().containsValue(value);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            this.delegate().replaceAll(function);
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            return this.delegate().computeIfAbsent(key, mappingFunction);
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            return this.delegate().computeIfPresent(key, remappingFunction);
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            return this.delegate().compute(key, remappingFunction);
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            return this.delegate().merge(key, value, remappingFunction);
        }

        @Override
        public Set<K> keySet() {
            return this.keySet == null ? (this.keySet = new KeySetView()) : this.keySet;
        }

        @Override
        public Collection<V> values() {
            return this.values == null ? (this.values = new ValuesView()) : this.values;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.entrySet == null ? (this.entrySet = new EntrySetView()) : this.entrySet;
        }

        @Override
        protected ConcurrentMap<K, V> delegate() {
            return CaffeinatedGuavaCache.this.cache.asMap();
        }
    }
}

