/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NetworkConnections;
import com.google.common.graph.StableDirectedMultiNetworkConnections;
import com.google.common.graph.StandardMutableNetwork;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@ElementTypesAreNonnullByDefault
public final class StableStandardMutableNetwork<N, E>
implements MutableNetwork<N, E> {
    private final StandardMutableNetwork<N, E> standardMutableNetwork;

    public StableStandardMutableNetwork(NetworkBuilder<? super N, ? super E> builder) {
        this.standardMutableNetwork = new StandardMutableNetwork<N, E>(builder);
    }

    @Override
    public boolean addNode(N node) {
        Preconditions.checkNotNull(node, "node");
        if (this.standardMutableNetwork.containsNode(node)) {
            return false;
        }
        this.addNodeInternal(node);
        return true;
    }

    @Override
    public boolean addEdge(N nodeU, N nodeV, E edge) {
        Preconditions.checkNotNull(nodeU, "nodeU");
        Preconditions.checkNotNull(nodeV, "nodeV");
        Preconditions.checkNotNull(edge, "edge");
        if (this.standardMutableNetwork.containsEdge(edge)) {
            EndpointPair<N> existingIncidentNodes = this.incidentNodes(edge);
            EndpointPair<N> newIncidentNodes = EndpointPair.of(this, nodeU, nodeV);
            Preconditions.checkArgument(existingIncidentNodes.equals(newIncidentNodes), "Edge %s already exists between the following nodes: %s, so it cannot be reused to connect the following nodes: %s.", edge, existingIncidentNodes, newIncidentNodes);
            return false;
        }
        NetworkConnections<N, E> connectionsU = (NetworkConnections<N, E>)this.standardMutableNetwork.nodeConnections.get(nodeU);
        if (!this.allowsParallelEdges()) {
            Preconditions.checkArgument(connectionsU == null || !connectionsU.successors().contains(nodeV), "Nodes %s and %s are already connected by a different edge. To construct a graph that allows parallel edges, call allowsParallelEdges(true) on the Builder.", nodeU, nodeV);
        }
        boolean isSelfLoop = nodeU.equals(nodeV);
        if (!this.allowsSelfLoops()) {
            Preconditions.checkArgument(!isSelfLoop, "Cannot add self-loop edge on node %s, as self-loops are not allowed. To construct a graph that allows self-loops, call allowsSelfLoops(true) on the Builder.", nodeU);
        }
        if (connectionsU == null) {
            connectionsU = this.addNodeInternal(nodeU);
        }
        connectionsU.addOutEdge(edge, nodeV);
        NetworkConnections<N, E> connectionsV = (NetworkConnections<N, E>)this.standardMutableNetwork.nodeConnections.get(nodeV);
        if (connectionsV == null) {
            connectionsV = this.addNodeInternal(nodeV);
        }
        connectionsV.addInEdge(edge, nodeU, isSelfLoop);
        this.standardMutableNetwork.edgeToReferenceNode.put(edge, nodeU);
        return true;
    }

    @CanIgnoreReturnValue
    private NetworkConnections<N, E> addNodeInternal(N node) {
        NetworkConnections<N, E> connections = this.newConnections();
        Preconditions.checkState(this.standardMutableNetwork.nodeConnections.put(node, connections) == null);
        return connections;
    }

    @Nonnull
    private NetworkConnections<N, E> newConnections() {
        Verify.verify(this.isDirected() && this.allowsParallelEdges(), "Only directed with parallel edges network is supported", new Object[0]);
        return StableDirectedMultiNetworkConnections.of();
    }

    @Override
    public Graph<N> asGraph() {
        return this.standardMutableNetwork.asGraph();
    }

    @Override
    public int degree(N node) {
        return this.standardMutableNetwork.degree(node);
    }

    @Override
    public int inDegree(N node) {
        return this.standardMutableNetwork.inDegree(node);
    }

    @Override
    public int outDegree(N node) {
        return this.standardMutableNetwork.outDegree(node);
    }

    @Override
    public Set<E> adjacentEdges(E edge) {
        return this.standardMutableNetwork.adjacentEdges(edge);
    }

    @Override
    public Set<E> edgesConnecting(EndpointPair<N> endpoints) {
        return this.standardMutableNetwork.edgesConnecting(endpoints);
    }

    @Override
    public Optional<E> edgeConnecting(N nodeU, N nodeV) {
        return this.standardMutableNetwork.edgeConnecting(nodeU, nodeV);
    }

    @Override
    public Optional<E> edgeConnecting(EndpointPair<N> endpoints) {
        return this.standardMutableNetwork.edgeConnecting(endpoints);
    }

    @Override
    @CheckForNull
    public E edgeConnectingOrNull(N nodeU, N nodeV) {
        return this.standardMutableNetwork.edgeConnectingOrNull(nodeU, nodeV);
    }

    @Override
    @CheckForNull
    public E edgeConnectingOrNull(EndpointPair<N> endpoints) {
        return this.standardMutableNetwork.edgeConnectingOrNull(endpoints);
    }

    @Override
    public boolean hasEdgeConnecting(N nodeU, N nodeV) {
        return this.standardMutableNetwork.hasEdgeConnecting(nodeU, nodeV);
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
        return this.standardMutableNetwork.hasEdgeConnecting(endpoints);
    }

    @Override
    public Set<N> nodes() {
        return this.standardMutableNetwork.nodes();
    }

    @Override
    public Set<E> edges() {
        return this.standardMutableNetwork.edges();
    }

    @Override
    public boolean isDirected() {
        return this.standardMutableNetwork.isDirected();
    }

    @Override
    public boolean allowsParallelEdges() {
        return this.standardMutableNetwork.allowsParallelEdges();
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.standardMutableNetwork.allowsSelfLoops();
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.standardMutableNetwork.nodeOrder();
    }

    @Override
    public ElementOrder<E> edgeOrder() {
        return this.standardMutableNetwork.edgeOrder();
    }

    @Override
    public Set<E> incidentEdges(N node) {
        return this.standardMutableNetwork.incidentEdges(node);
    }

    @Override
    public EndpointPair<N> incidentNodes(E edge) {
        return this.standardMutableNetwork.incidentNodes(edge);
    }

    @Override
    public Set<N> adjacentNodes(N node) {
        return this.standardMutableNetwork.adjacentNodes(node);
    }

    @Override
    public Set<E> edgesConnecting(N nodeU, N nodeV) {
        return this.standardMutableNetwork.edgesConnecting(nodeU, nodeV);
    }

    @Override
    public Set<E> inEdges(N node) {
        return this.standardMutableNetwork.inEdges(node);
    }

    @Override
    public Set<E> outEdges(N node) {
        return this.standardMutableNetwork.outEdges(node);
    }

    @Override
    public Set<N> predecessors(N node) {
        return this.standardMutableNetwork.predecessors((Object)node);
    }

    @Override
    public Set<N> successors(N node) {
        return this.standardMutableNetwork.successors((Object)node);
    }

    @Override
    public boolean addEdge(EndpointPair<N> endpoints, E edge) {
        return this.standardMutableNetwork.addEdge(endpoints, edge);
    }

    @Override
    public boolean removeNode(N node) {
        return this.standardMutableNetwork.removeNode(node);
    }

    @Override
    public boolean removeEdge(E edge) {
        return this.standardMutableNetwork.removeEdge(edge);
    }
}

