/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.grpc.Metadata;
import io.prometheus.client.SimpleCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.dinowernli.grpc.prometheus.GrpcMethod;

class Labels {
    Labels() {
    }

    static String[] asArray(List<String> firstList, List<String> secondList) {
        ArrayList<String> list = new ArrayList<String>(firstList);
        list.addAll(secondList);
        return list.toArray(new String[0]);
    }

    static List<Metadata.Key<String>> metadataKeys(List<String> headerNames) {
        ArrayList<Metadata.Key<String>> keys = new ArrayList<Metadata.Key<String>>();
        for (String name : headerNames) {
            keys.add(Metadata.Key.of(name, Metadata.ASCII_STRING_MARSHALLER));
        }
        return Collections.unmodifiableList(keys);
    }

    static List<String> customLabels(Metadata metadata, List<Metadata.Key<String>> labelHeaderKeys) {
        ArrayList<String> labels = new ArrayList<String>();
        for (Metadata.Key<String> key : labelHeaderKeys) {
            if (metadata.containsKey(key)) {
                labels.add(metadata.get(key));
                continue;
            }
            labels.add("");
        }
        return Collections.unmodifiableList(labels);
    }

    static <T> T addLabels(SimpleCollector<T> collector, List<String> labels, GrpcMethod method) {
        ArrayList<String> allLabels = new ArrayList<String>();
        allLabels.add(method.type());
        allLabels.add(method.serviceName());
        allLabels.add(method.methodName());
        allLabels.addAll(labels);
        return collector.labels(allLabels.toArray(new String[0]));
    }
}

