/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.grpc.ClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.Status;
import java.time.Clock;
import java.time.Instant;
import me.dinowernli.grpc.prometheus.ClientMetrics;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.GrpcMethod;

class MonitoringClientCallListener<S>
extends ForwardingClientCallListener<S> {
    private static final long MILLIS_PER_SECOND = 1000L;
    private final ClientCall.Listener<S> delegate;
    private final ClientMetrics clientMetrics;
    private final GrpcMethod grpcMethod;
    private final Configuration configuration;
    private final Clock clock;
    private final Instant startInstant;
    private final Metadata requestMetadata;

    MonitoringClientCallListener(ClientCall.Listener<S> delegate, ClientMetrics clientMetrics, GrpcMethod grpcMethod, Configuration configuration, Clock clock, Metadata requestMetadata) {
        this.delegate = delegate;
        this.clientMetrics = clientMetrics;
        this.grpcMethod = grpcMethod;
        this.configuration = configuration;
        this.clock = clock;
        this.startInstant = clock.instant();
        this.requestMetadata = requestMetadata;
    }

    @Override
    protected ClientCall.Listener<S> delegate() {
        return this.delegate;
    }

    @Override
    public void onClose(Status status, Metadata metadata) {
        this.clientMetrics.recordClientHandled(status.getCode(), this.requestMetadata);
        if (this.configuration.isIncludeLatencyHistograms()) {
            double latencySec = (double)(this.clock.millis() - this.startInstant.toEpochMilli()) / 1000.0;
            this.clientMetrics.recordLatency(latencySec, this.requestMetadata);
        }
        super.onClose(status, metadata);
    }

    @Override
    public void onMessage(S responseMessage) {
        if (this.grpcMethod.streamsResponses()) {
            this.clientMetrics.recordStreamMessageReceived(this.requestMetadata);
        }
        super.onMessage(responseMessage);
    }
}

