/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import me.dinowernli.grpc.prometheus.GrpcMethod;
import me.dinowernli.grpc.prometheus.ServerMetrics;

class MonitoringServerCallListener<R>
extends ForwardingServerCallListener<R> {
    private final ServerCall.Listener<R> delegate;
    private final GrpcMethod grpcMethod;
    private final ServerMetrics serverMetrics;
    private final Metadata requestMetadata;

    MonitoringServerCallListener(ServerCall.Listener<R> delegate, ServerMetrics serverMetrics, GrpcMethod grpcMethod, Metadata requestMetadata) {
        this.delegate = delegate;
        this.serverMetrics = serverMetrics;
        this.grpcMethod = grpcMethod;
        this.requestMetadata = requestMetadata;
    }

    @Override
    protected ServerCall.Listener<R> delegate() {
        return this.delegate;
    }

    @Override
    public void onMessage(R request) {
        if (this.grpcMethod.streamsRequests()) {
            this.serverMetrics.recordStreamMessageReceived(this.requestMetadata);
        }
        super.onMessage(request);
    }
}

