/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.time.Clock;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.GrpcMethod;
import me.dinowernli.grpc.prometheus.MonitoringServerCall;
import me.dinowernli.grpc.prometheus.MonitoringServerCallListener;
import me.dinowernli.grpc.prometheus.ServerMetrics;

public class MonitoringServerInterceptor
implements ServerInterceptor {
    private final Clock clock;
    private final Configuration configuration;
    private final ServerMetrics.Factory serverMetricsFactory;

    public static MonitoringServerInterceptor create(Configuration configuration) {
        return new MonitoringServerInterceptor(Clock.systemDefaultZone(), configuration, new ServerMetrics.Factory(configuration));
    }

    private MonitoringServerInterceptor(Clock clock, Configuration configuration, ServerMetrics.Factory serverMetricsFactory) {
        this.clock = clock;
        this.configuration = configuration;
        this.serverMetricsFactory = serverMetricsFactory;
    }

    public <R, S> ServerCall.Listener<R> interceptCall(ServerCall<R, S> call, Metadata requestMetadata, ServerCallHandler<R, S> next) {
        MethodDescriptor<R, S> methodDescriptor = call.getMethodDescriptor();
        GrpcMethod grpcMethod = GrpcMethod.of(methodDescriptor);
        ServerMetrics metrics = this.serverMetricsFactory.createMetricsForMethod(grpcMethod);
        MonitoringServerCall<R, S> monitoringCall = new MonitoringServerCall<R, S>(call, this.clock, grpcMethod, metrics, this.configuration, requestMetadata);
        return new MonitoringServerCallListener<R>(next.startCall(monitoringCall, requestMetadata), metrics, grpcMethod, requestMetadata);
    }
}

