/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.grpc.Metadata;
import io.grpc.Status;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.GrpcMethod;
import me.dinowernli.grpc.prometheus.Labels;

class ServerMetrics {
    private static final List<String> defaultRequestLabels = Arrays.asList("grpc_type", "grpc_service", "grpc_method");
    private static final String STATUS_CODE_LABEL = "grpc_code";
    private static final List<String> defaultResponseLabels = Arrays.asList("grpc_type", "grpc_service", "grpc_method", "code", "grpc_code");
    private static final Counter.Builder serverStartedBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("server")).name("started")).help("Total number of RPCs started on the server.");
    private static final Counter.Builder serverHandledBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("server")).name("handled")).help("Total number of RPCs completed on the server, regardless of success or failure.");
    private static final Histogram.Builder serverHandledLatencySecondsBuilder = (Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("grpc")).subsystem("server")).name("handled_latency_seconds")).help("Histogram of response latency (seconds) of gRPC that had been application-level handled by the server.");
    private static final Counter.Builder serverStreamMessagesReceivedBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("server")).name("msg_received")).help("Total number of stream messages received from the client.");
    private static final Counter.Builder serverStreamMessagesSentBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("server")).name("msg_sent")).help("Total number of stream messages sent by the server.");
    private final List<Metadata.Key<String>> labelHeaderKeys;
    private final Counter serverStarted;
    private final Counter serverHandled;
    private final Counter serverStreamMessagesReceived;
    private final Counter serverStreamMessagesSent;
    private final Optional<Histogram> serverHandledLatencySeconds;
    private final boolean isAddCodeLabelToHistograms;
    private final GrpcMethod method;

    private ServerMetrics(List<Metadata.Key<String>> labelHeaderKeys, GrpcMethod method, Counter serverStarted, Counter serverHandled, Counter serverStreamMessagesReceived, Counter serverStreamMessagesSent, Optional<Histogram> serverHandledLatencySeconds, boolean isAddCodeLabelToHistograms) {
        this.labelHeaderKeys = labelHeaderKeys;
        this.method = method;
        this.serverStarted = serverStarted;
        this.serverHandled = serverHandled;
        this.serverStreamMessagesReceived = serverStreamMessagesReceived;
        this.serverStreamMessagesSent = serverStreamMessagesSent;
        this.serverHandledLatencySeconds = serverHandledLatencySeconds;
        this.isAddCodeLabelToHistograms = isAddCodeLabelToHistograms;
    }

    public void recordCallStarted(Metadata metadata) {
        Labels.addLabels(this.serverStarted, Labels.customLabels(metadata, this.labelHeaderKeys), this.method).inc();
    }

    public void recordServerHandled(Status.Code code, Metadata metadata) {
        ArrayList<String> allLabels = new ArrayList<String>();
        allLabels.add(code.toString());
        allLabels.add(code.toString());
        allLabels.addAll(Labels.customLabels(metadata, this.labelHeaderKeys));
        Labels.addLabels(this.serverHandled, allLabels, this.method).inc();
    }

    public void recordStreamMessageSent(Metadata metadata) {
        Labels.addLabels(this.serverStreamMessagesSent, Labels.customLabels(metadata, this.labelHeaderKeys), this.method).inc();
    }

    public void recordStreamMessageReceived(Metadata metadata) {
        Labels.addLabels(this.serverStreamMessagesReceived, Labels.customLabels(metadata, this.labelHeaderKeys), this.method).inc();
    }

    public void recordLatency(double latencySec, Metadata metadata, Status.Code code) {
        if (!this.serverHandledLatencySeconds.isPresent()) {
            return;
        }
        ArrayList<String> allLabels = new ArrayList<String>();
        allLabels.addAll(Labels.customLabels(metadata, this.labelHeaderKeys));
        if (this.isAddCodeLabelToHistograms) {
            allLabels.add(code.toString());
        }
        ((Histogram.Child)Labels.addLabels(this.serverHandledLatencySeconds.get(), allLabels, this.method)).observe(latencySec);
    }

    static class Factory {
        private final List<Metadata.Key<String>> labelHeaderKeys;
        private final Counter serverStarted;
        private final Counter serverHandled;
        private final Counter serverStreamMessagesReceived;
        private final Counter serverStreamMessagesSent;
        private final Optional<Histogram> serverHandledLatencySeconds;
        private final boolean isAddCodeLabelToHistograms;

        Factory(Configuration configuration) {
            CollectorRegistry registry = configuration.getCollectorRegistry();
            this.labelHeaderKeys = Labels.metadataKeys(configuration.getLabelHeaders());
            this.serverStarted = (Counter)((Counter.Builder)serverStartedBuilder.labelNames(Labels.asArray(defaultRequestLabels, configuration.getSanitizedLabelHeaders()))).register(registry);
            this.serverHandled = (Counter)((Counter.Builder)serverHandledBuilder.labelNames(Labels.asArray(defaultResponseLabels, configuration.getSanitizedLabelHeaders()))).register(registry);
            this.serverStreamMessagesReceived = (Counter)((Counter.Builder)serverStreamMessagesReceivedBuilder.labelNames(Labels.asArray(defaultRequestLabels, configuration.getSanitizedLabelHeaders()))).register(registry);
            this.serverStreamMessagesSent = (Counter)((Counter.Builder)serverStreamMessagesSentBuilder.labelNames(Labels.asArray(defaultRequestLabels, configuration.getSanitizedLabelHeaders()))).register(registry);
            if (configuration.isIncludeLatencyHistograms()) {
                ArrayList<String> labels = new ArrayList<String>();
                labels.addAll(defaultRequestLabels);
                labels.addAll(configuration.getSanitizedLabelHeaders());
                if (configuration.isAddCodeLabelToHistograms()) {
                    labels.add(ServerMetrics.STATUS_CODE_LABEL);
                }
                this.isAddCodeLabelToHistograms = configuration.isAddCodeLabelToHistograms();
                this.serverHandledLatencySeconds = Optional.of((Histogram)((Histogram.Builder)serverHandledLatencySecondsBuilder.buckets(configuration.getLatencyBuckets()).labelNames(labels.toArray(new String[0]))).register(registry));
            } else {
                this.serverHandledLatencySeconds = Optional.empty();
                this.isAddCodeLabelToHistograms = false;
            }
        }

        ServerMetrics createMetricsForMethod(GrpcMethod grpcMethod) {
            return new ServerMetrics(this.labelHeaderKeys, grpcMethod, this.serverStarted, this.serverHandled, this.serverStreamMessagesReceived, this.serverStreamMessagesSent, this.serverHandledLatencySeconds, this.isAddCodeLabelToHistograms);
        }
    }
}

