package com.foxcode.android.common.nointernet.ui

import android.app.Activity
import androidx.lifecycle.Lifecycle
import com.foxcode.android.common.R
import com.foxcode.android.common.databinding.DialogNoInternetBinding
import com.foxcode.android.common.nointernet.ui.base.BaseNoInternetDialog
import com.foxcode.android.common.nointernet.utils.NoInternetUtils

class NoInternetDialog private constructor(
    activity: Activity,
    lifecycle: Lifecycle,
    private val dialogProperties: DialogProperties
) : BaseNoInternetDialog(activity, lifecycle, dialogProperties, R.style.Dialog_NoInternet) {
    private lateinit var binding: DialogNoInternetBinding

    override fun setLayout() {
        binding = DialogNoInternetBinding.inflate(layoutInflater)
        setContentView(binding.root)
    }

    override fun initView() {
        binding.tvTitle.text = dialogProperties.noInternetConnectionTitle
        binding.tvMessage.text = dialogProperties.noInternetConnectionMessage
        binding.btnWifiOn.text = dialogProperties.wifiOnButtonText
        binding.btnMobileDataOn.text = dialogProperties.mobileDataOnButtonText

        initListeners()
    }

    private fun initListeners() {
        binding.btnWifiOn.setOnClickListener {
            NoInternetUtils.turnOnWifi(context)
        }

        binding.btnMobileDataOn.setOnClickListener {
            NoInternetUtils.turnOnMobileData(context)
        }
    }

    override fun onShow(isAirplaneModeOn: Boolean) {
        // no-op
    }

    override fun onDismiss() {
        // no-op
    }

    override fun onDestroy() {
        // no-op
    }

    class Builder(
        private val activity: Activity,
        private val lifecycle: Lifecycle
    ) {
        val dialogProperties = DialogProperties()

        init {
            dialogProperties.apply {
                cancelable = false
                connectionCallback = null
                noInternetConnectionTitle = activity.getString(R.string.fox_common_no_internet_connection_default_title)
                noInternetConnectionMessage = activity.getString(R.string.fox_common_no_internet_connection_default_message)
                wifiOnButtonText = activity.getString(R.string.fox_common_turn_on_wifi_cta)
                mobileDataOnButtonText = activity.getString(R.string.fox_common_turn_on_mobile_data_cta)
            }
        }

        fun build(): NoInternetDialog {
            return NoInternetDialog(
                activity,
                lifecycle,
                dialogProperties
            )
        }
    }
}
