/*
 * Decompiled with CFR 0.152.
 */
package com.foxcode.android.common.nointernet.ui.base;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.Window;
import androidx.annotation.StyleRes;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import com.foxcode.android.common.nointernet.callbacks.ConnectionCallback;
import com.foxcode.android.common.nointernet.components.NoInternetObserveComponent;
import com.foxcode.android.common.nointernet.ui.DialogProperties;
import com.foxcode.android.common.nointernet.utils.NoInternetUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0010\u001a\u00020\u0011J\r\u0010\u0012\u001a\u00020\u0011H \u00a2\u0006\u0002\b\u0013J\u0012\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\r\u0010\u0017\u001a\u00020\u0011H \u00a2\u0006\u0002\b\u0018J\r\u0010\u0019\u001a\u00020\u0011H \u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH \u00a2\u0006\u0002\b\u001eJ\b\u0010\u001f\u001a\u00020\u0011H\u0014J\r\u0010 \u001a\u00020\u0011H \u00a2\u0006\u0002\b!J\u0012\u0010\"\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020\u0011H\u0002J\b\u0010&\u001a\u00020\u0011H\u0002J\b\u0010'\u001a\u00020\u0011H\u0016J\u0006\u0010(\u001a\u00020\u0011J\u0006\u0010)\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/foxcode/android/common/nointernet/ui/base/BaseNoInternetDialog;", "Landroid/app/Dialog;", "Landroidx/lifecycle/LifecycleObserver;", "activity", "Landroid/app/Activity;", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "dialogProperties", "Lcom/foxcode/android/common/nointernet/ui/DialogProperties;", "themeResId", "", "(Landroid/app/Activity;Landroidx/lifecycle/Lifecycle;Lcom/foxcode/android/common/nointernet/ui/DialogProperties;I)V", "connectionCallback", "Lcom/foxcode/android/common/nointernet/callbacks/ConnectionCallback;", "noInternetObserveComponent", "Lcom/foxcode/android/common/nointernet/components/NoInternetObserveComponent;", "destroy", "", "initView", "initView$fox_common_release", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onDestroy$fox_common_release", "onDismiss", "onDismiss$fox_common_release", "onShow", "isAirplaneModeOn", "", "onShow$fox_common_release", "onStop", "setLayout", "setLayout$fox_common_release", "setOnDismissListener", "listener", "Landroid/content/DialogInterface$OnDismissListener;", "setProperties", "setupDialog", "show", "start", "stop", "fox_common_release"})
public abstract class BaseNoInternetDialog
extends Dialog
implements LifecycleObserver {
    @NotNull
    private final Activity activity;
    @NotNull
    private final Lifecycle lifecycle;
    @NotNull
    private final DialogProperties dialogProperties;
    @NotNull
    private NoInternetObserveComponent noInternetObserveComponent;
    @Nullable
    private ConnectionCallback connectionCallback;

    public BaseNoInternetDialog(@NotNull Activity activity, @NotNull Lifecycle lifecycle, @NotNull DialogProperties dialogProperties, @StyleRes int themeResId) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
        Intrinsics.checkNotNullParameter((Object)dialogProperties, (String)"dialogProperties");
        super((Context)activity, themeResId);
        this.activity = activity;
        this.lifecycle = lifecycle;
        this.dialogProperties = dialogProperties;
        this.connectionCallback = this.dialogProperties.getConnectionCallback();
        Context context = this.activity.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
        this.noInternetObserveComponent = new NoInternetObserveComponent(context, this.lifecycle, new NoInternetObserveComponent.NoInternetObserverListener(){

            @Override
            public void onStart() {
            }

            @Override
            public void onConnected() {
                ConnectionCallback connectionCallback = connectionCallback;
                if (connectionCallback != null) {
                    connectionCallback.hasActiveConnection(true);
                }
                this.dismiss();
            }

            @Override
            public void onDisconnected(boolean isAirplaneModeOn) {
                ConnectionCallback connectionCallback = connectionCallback;
                if (connectionCallback != null) {
                    connectionCallback.hasActiveConnection(false);
                }
                this.show();
            }

            @Override
            public void onStop() {
                this.destroy();
            }
        });
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.lifecycle.addObserver((LifecycleObserver)this);
        this.setLayout$fox_common_release();
        this.initView$fox_common_release();
        this.setProperties();
        this.setupDialog();
    }

    private final void setProperties() {
        this.setCancelable(this.dialogProperties.getCancelable());
    }

    private final void setupDialog() {
        block0: {
            Window window;
            Window window2 = this.getWindow();
            if (window2 == null) break block0;
            Window $this$setupDialog_u24lambda_u240 = window = window2;
            boolean bl = false;
            $this$setupDialog_u24lambda_u240.setLayout(-1, -1);
            $this$setupDialog_u24lambda_u240.setGravity(17);
            $this$setupDialog_u24lambda_u240.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
    }

    public void show() {
        if (!this.activity.isFinishing() && this.lifecycle.getCurrentState().isAtLeast(Lifecycle.State.RESUMED)) {
            super.show();
            this.onShow$fox_common_release(NoInternetUtils.isAirplaneModeOn((Context)this.activity));
        }
    }

    public void setOnDismissListener(@Nullable DialogInterface.OnDismissListener listener) {
        super.setOnDismissListener(listener);
    }

    protected void onStop() {
        super.onStop();
        this.onDismiss$fox_common_release();
    }

    public final void destroy() {
        this.onDestroy$fox_common_release();
        this.dismiss();
    }

    public final void start() {
        this.noInternetObserveComponent.start();
    }

    public final void stop() {
        this.noInternetObserveComponent.stop();
    }

    public abstract void setLayout$fox_common_release();

    public abstract void initView$fox_common_release();

    public abstract void onShow$fox_common_release(boolean var1);

    public abstract void onDismiss$fox_common_release();

    public abstract void onDestroy$fox_common_release();
}

