/*
 * Decompiled with CFR 0.152.
 */
package com.foxcode.android.common.nointernet.utils;

import android.content.Context;
import android.graphics.Insets;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowMetrics;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0002\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\u0004*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\f"}, d2={"fixWidth", "", "Landroid/view/Window;", "layoutWidthInDp", "", "layoutTotalHorizontalMarginInDp", "getAppWindowWidth", "toDp", "", "context", "Landroid/content/Context;", "toPx", "fox_common_release"})
@JvmName(name="Utils")
public final class Utils {
    public static final float toDp(float $this$toDp, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return $this$toDp / ((float)context.getResources().getDisplayMetrics().densityDpi / (float)160);
    }

    public static final int toPx(float $this$toPx, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (int)($this$toPx * ((float)context.getResources().getDisplayMetrics().densityDpi / (float)160));
    }

    public static final int getAppWindowWidth(@NotNull Window $this$getAppWindowWidth) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getAppWindowWidth, (String)"<this>");
        if (Build.VERSION.SDK_INT >= 30) {
            WindowMetrics windowMetrics = $this$getAppWindowWidth.getWindowManager().getCurrentWindowMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"getCurrentWindowMetrics(...)");
            WindowMetrics windowMetrics2 = windowMetrics;
            Insets insets = windowMetrics2.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemBars());
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsetsIgnoringVisibility(...)");
            Insets insets2 = insets;
            n = windowMetrics2.getBounds().width() - insets2.left - insets2.right;
        } else {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            $this$getAppWindowWidth.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            n = displayMetrics.widthPixels;
        }
        return n;
    }

    public static final void fixWidth(@NotNull Window $this$fixWidth, int layoutWidthInDp, int layoutTotalHorizontalMarginInDp) {
        Intrinsics.checkNotNullParameter((Object)$this$fixWidth, (String)"<this>");
        float f = Utils.getAppWindowWidth($this$fixWidth);
        Context context = $this$fixWidth.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        float widthDp = Utils.toDp(f, context);
        Log.d((String)"fixWidth", (String)("layout original width: " + layoutWidthInDp + " dp"));
        Log.d((String)"fixWidth", (String)("layout total horizontal margin: " + layoutTotalHorizontalMarginInDp + " dp"));
        Log.d((String)"fixWidth", (String)("app window width: " + widthDp + " dp"));
        if (widthDp < (float)(layoutWidthInDp + layoutTotalHorizontalMarginInDp)) {
            float f2 = widthDp - (float)layoutTotalHorizontalMarginInDp;
            Context context2 = $this$fixWidth.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
            $this$fixWidth.setLayout(Utils.toPx(f2, context2), -2);
        } else {
            float f3 = layoutWidthInDp;
            Context context3 = $this$fixWidth.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"getContext(...)");
            $this$fixWidth.setLayout(Utils.toPx(f3, context3), -2);
        }
    }
}

