/*
 * Decompiled with CFR 0.152.
 */
package org.foxlabs.util;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class Assert {
    public static void assertTrue(boolean flag, String message) {
        if (!flag) {
            throw Assert.assertError(message);
        }
    }

    public static void assertFalse(boolean flag, String message) {
        if (flag) {
            throw Assert.assertError(message);
        }
    }

    public static <T> T notNull(T object, String message) {
        if (object == null) {
            throw Assert.assertError(message);
        }
        return object;
    }

    public static String notEmpty(String string, String message) {
        if (string == null || string.isEmpty()) {
            throw Assert.assertError(message);
        }
        return string;
    }

    public static <T> T[] notEmpty(T[] array, String message) {
        if (array == null || array.length == 0) {
            throw Assert.assertError(message);
        }
        return array;
    }

    public static <T extends Collection<?>> T notEmpty(T collection, String message) {
        if (collection == null || collection.isEmpty()) {
            throw Assert.assertError(message);
        }
        return collection;
    }

    public static <T> T[] noNullElements(T[] array, String message) {
        if (array == null || array.length == 0) {
            throw Assert.assertError(message);
        }
        for (T element : array) {
            if (element != null) continue;
            throw Assert.assertError(message);
        }
        return array;
    }

    public static <T extends Collection<?>> T noNullElements(T collection, String message) {
        if (collection == null || collection.isEmpty()) {
            throw Assert.assertError(message);
        }
        for (Object element : collection) {
            if (element != null) continue;
            throw Assert.assertError(message);
        }
        return collection;
    }

    public static String[] noEmptyElements(String[] array, String message) {
        if (array == null || array.length == 0) {
            throw Assert.assertError(message);
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null && !array[i].isEmpty()) continue;
            throw Assert.assertError(message);
        }
        return array;
    }

    public static <T extends Collection<String>> T noEmptyElements(T collection, String message) {
        if (collection == null || collection.isEmpty()) {
            throw Assert.assertError(message);
        }
        for (String element : collection) {
            if (element != null && !element.isEmpty()) continue;
            throw Assert.assertError(message);
        }
        return collection;
    }

    public static Set<String> noNullStringSet(String[] array, String message) {
        if (array == null || array.length == 0) {
            throw Assert.assertError(message);
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>(array.length);
        for (String element : array) {
            if (element == null) {
                throw Assert.assertError(message);
            }
            set.add(element);
        }
        return set;
    }

    public static Set<String> noEmptyStringSet(String[] array, String message) {
        if (array == null || array.length == 0) {
            throw Assert.assertError(message);
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>(array.length);
        for (String element : array) {
            if (element == null || element.isEmpty()) {
                throw Assert.assertError(message);
            }
            set.add(element);
        }
        return set;
    }

    public static int notNegative(int value, String message) {
        if (value < 0) {
            throw Assert.assertError(message);
        }
        return value;
    }

    public static long notNegative(long value, String message) {
        if (value < 0L) {
            throw Assert.assertError(message);
        }
        return value;
    }

    public static float notNegative(float value, String message) {
        if (value < 0.0f) {
            throw Assert.assertError(message);
        }
        return value;
    }

    public static double notNegative(double value, String message) {
        if (value < 0.0) {
            throw Assert.assertError(message);
        }
        return value;
    }

    public static int notNegativeOrZero(int value, String message) {
        if (value <= 0) {
            throw Assert.assertError(message);
        }
        return value;
    }

    public static long notNegativeOrZero(long value, String message) {
        if (value <= 0L) {
            throw Assert.assertError(message);
        }
        return value;
    }

    public static float notNegativeOrZero(float value, String message) {
        if (value <= 0.0f) {
            throw Assert.assertError(message);
        }
        return value;
    }

    public static double notNegativeOrZero(double value, String message) {
        if (value <= 0.0) {
            throw Assert.assertError(message);
        }
        return value;
    }

    protected static IllegalArgumentException assertError(String message) {
        IllegalArgumentException exception = new IllegalArgumentException(message);
        StackTraceElement[] oldTrace = exception.getStackTrace();
        StackTraceElement[] newTrace = new StackTraceElement[oldTrace.length - 1];
        System.arraycopy(oldTrace, 1, newTrace, 0, newTrace.length);
        exception.setStackTrace(newTrace);
        return exception;
    }
}

