/*
 * Decompiled with CFR 0.152.
 */
package org.foxlabs.util;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.foxlabs.util.resource.Service;

public class PeriodCounter {
    protected final Locale locale;
    public static final PeriodCounter ENGLISH = new PeriodCounter(Locale.ENGLISH);
    public static final PeriodCounter RUSSIAN = new PeriodCounter(new Locale("ru")){

        @Override
        protected String getNowPeriod() {
            return "\u0421\u0435\u0439\u0447\u0430\u0441";
        }

        @Override
        protected String getMinutePeriod(int count, boolean future) {
            return count == 1 ? (future ? "\u0427\u0435\u0440\u0435\u0437 \u043c\u0438\u043d\u0443\u0442\u0443" : "\u041c\u0438\u043d\u0443\u0442\u0443 \u043d\u0430\u0437\u0430\u0434") : (count > 20 && count % 10 == 1 ? (future ? "\u0427\u0435\u0440\u0435\u0437 " + count + " \u043c\u0438\u043d\u0443\u0442\u0443" : count + " \u043c\u0438\u043d\u0443\u0442\u0443 \u043d\u0430\u0437\u0430\u0434") : ((count < 10 || count > 20) && count % 10 > 0 && count % 10 < 5 ? (future ? "\u0427\u0435\u0440\u0435\u0437 " + count + " \u043c\u0438\u043d\u0443\u0442\u044b" : count + " \u043c\u0438\u043d\u0443\u0442\u044b \u043d\u0430\u0437\u0430\u0434") : (future ? "\u0427\u0435\u0440\u0435\u0437 " + count + " \u043c\u0438\u043d\u0443\u0442" : count + " \u043c\u0438\u043d\u0443\u0442 \u043d\u0430\u0437\u0430\u0434")));
        }

        @Override
        protected String getHourPeriod(int count, boolean future) {
            return count == 1 ? (future ? "\u0427\u0435\u0440\u0435\u0437 \u0447\u0430\u0441" : "\u0427\u0430\u0441 \u043d\u0430\u0437\u0430\u0434") : (count > 20 && count % 10 == 1 ? (future ? "\u0427\u0435\u0440\u0435\u0437 " + count + " \u0447\u0430\u0441" : count + " \u0447\u0430\u0441 \u043d\u0430\u0437\u0430\u0434") : ((count < 10 || count > 20) && count % 10 < 5 ? (future ? "\u0427\u0435\u0440\u0435\u0437 " + count + " \u0447\u0430\u0441\u0430" : count + " \u0447\u0430\u0441\u0430 \u043d\u0430\u0437\u0430\u0434") : (future ? "\u0427\u0435\u0440\u0435\u0437 " + count + " \u0447\u0430\u0441\u043e\u0432" : count + " \u0447\u0430\u0441\u043e\u0432 \u043d\u0430\u0437\u0430\u0434")));
        }

        @Override
        protected String getDayPeriod(int count, boolean future) {
            return count == 1 ? (future ? "\u0427\u0435\u0440\u0435\u0437 \u0434\u0435\u043d\u044c" : "\u0414\u0435\u043d\u044c \u043d\u0430\u0437\u0430\u0434") : (count > 20 && count % 10 == 1 ? (future ? "\u0427\u0435\u0440\u0435\u0437 " + count + " \u0434\u0435\u043d\u044c" : count + " \u0434\u0435\u043d\u044c \u043d\u0430\u0437\u0430\u0434") : ((count < 10 || count > 20) && count % 10 > 0 && count % 10 < 5 ? (future ? "\u0427\u0435\u0440\u0435\u0437 " + count + " \u0434\u043d\u044f" : count + " \u0434\u043d\u044f \u043d\u0430\u0437\u0430\u0434") : (future ? "\u0427\u0435\u0440\u0435\u0437 " + count + " \u0434\u043d\u0435\u0439" : count + " \u0434\u043d\u0435\u0439 \u043d\u0430\u0437\u0430\u0434")));
        }

        @Override
        protected String getWeekPeriod(int count, boolean future) {
            return count == 1 ? (future ? "\u0427\u0435\u0440\u0435\u0437 \u043d\u0435\u0434\u0435\u043b\u044e" : "\u041d\u0435\u0434\u0435\u043b\u044e \u043d\u0430\u0437\u0430\u0434") : (future ? "\u0427\u0435\u0440\u0435\u0437 " + count + " \u043d\u0435\u0434\u0435\u043b\u0438" : count + " \u043d\u0435\u0434\u0435\u043b\u0438 \u043d\u0430\u0437\u0430\u0434");
        }

        @Override
        protected String getMonthPeriod(int count, boolean future) {
            return count == 1 ? (future ? "\u0427\u0435\u0440\u0435\u0437 \u043c\u0435\u0441\u044f\u0446" : "\u041c\u0435\u0441\u044f\u0446 \u043d\u0430\u0437\u0430\u0434") : (count < 5 ? (future ? "\u0427\u0435\u0440\u0435\u0437 " + count + " \u043c\u0435\u0441\u044f\u0446\u0430" : count + " \u043c\u0435\u0441\u044f\u0446\u0430 \u043d\u0430\u0437\u0430\u0434") : (future ? "\u0427\u0435\u0440\u0435\u0437 " + count + " \u043c\u0435\u0441\u044f\u0446\u0435\u0432" : count + " \u043c\u0435\u0441\u044f\u0446\u0435\u0432 \u043d\u0430\u0437\u0430\u0434"));
        }

        @Override
        protected String getYearPeriod(int count, boolean future) {
            return count == 1 ? (future ? "\u0427\u0435\u0440\u0435\u0437 \u0433\u043e\u0434" : "\u0413\u043e\u0434 \u043d\u0430\u0437\u0430\u0434") : (count > 20 && count % 10 == 1 ? (future ? "\u0427\u0435\u0440\u0435\u0437 " + count + " \u0433\u043e\u0434" : count + " \u0433\u043e\u0434 \u043d\u0430\u0437\u0430\u0434") : ((count < 10 || count > 20) && count % 10 > 0 && count % 10 < 5 ? (future ? "\u0427\u0435\u0440\u0435\u0437 " + count + " \u0433\u043e\u0434\u0430" : count + " \u0433\u043e\u0434\u0430 \u043d\u0430\u0437\u0430\u0434") : (future ? "\u0427\u0435\u0440\u0435\u0437 " + count + " \u043b\u0435\u0442" : count + " \u043b\u0435\u0442 \u043d\u0430\u0437\u0430\u0434")));
        }
    };
    static final Map<Locale, PeriodCounter> counters = new HashMap<Locale, PeriodCounter>();

    protected PeriodCounter(Locale locale) {
        this.locale = locale;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final String evaluate(Date date) {
        boolean future;
        Calendar now = Calendar.getInstance(this.locale);
        Calendar src = Calendar.getInstance(this.locale);
        Calendar tst = Calendar.getInstance(this.locale);
        src.setTime(date);
        boolean bl = future = src.compareTo(now) > 0;
        if (future) {
            Calendar cal = src;
            src = now;
            now = cal;
        }
        tst.setTime(date);
        tst.add(12, 1);
        if (now.compareTo(tst) < 0) {
            return this.getNowPeriod();
        }
        tst.setTime(date);
        tst.add(11, 1);
        if (now.compareTo(tst) < 0) {
            int count = now.get(11) == src.get(11) ? now.get(12) - src.get(12) : now.get(12) + src.getActualMaximum(12) - src.get(12);
            return this.getMinutePeriod(count, future);
        }
        tst.setTime(date);
        tst.add(5, 1);
        if (now.compareTo(tst) < 0) {
            int count = now.get(5) == src.get(5) ? now.get(11) - src.get(11) : now.get(11) + src.getActualMaximum(11) - src.get(11);
            return this.getHourPeriod(count, future);
        }
        tst.setTime(date);
        tst.add(4, 1);
        if (now.compareTo(tst) < 0) {
            int count = now.get(4) == src.get(4) ? now.get(7) - src.get(7) : now.get(7) + src.getActualMaximum(7) - src.get(7);
            return this.getDayPeriod(count, future);
        }
        tst.setTime(date);
        tst.add(2, 1);
        if (now.compareTo(tst) < 0) {
            int count = now.get(2) == src.get(2) ? now.get(4) - src.get(4) : now.get(4) + src.getActualMaximum(4) - src.get(4);
            return this.getWeekPeriod(count, future);
        }
        tst.setTime(date);
        tst.add(1, 1);
        if (now.compareTo(tst) < 0) {
            int count = now.get(1) == src.get(1) ? now.get(2) - src.get(2) : now.get(2) + src.getActualMaximum(2) - src.get(2);
            return this.getMonthPeriod(count, future);
        }
        return this.getYearPeriod(now.get(1) - src.get(1), future);
    }

    protected String getNowPeriod() {
        return "just now";
    }

    protected String getMinutePeriod(int count, boolean future) {
        return count == 1 ? (future ? "in a minute" : "a minute ago") : (future ? count + " minutes" : count + " minutes ago");
    }

    protected String getHourPeriod(int count, boolean future) {
        return count == 1 ? (future ? "in an hour" : "a hour ago") : (future ? count + " hours" : count + " hours ago");
    }

    protected String getDayPeriod(int count, boolean future) {
        return count == 1 ? (future ? "a day about" : "a day ago") : (future ? count + " days" : count + " days ago");
    }

    protected String getWeekPeriod(int count, boolean future) {
        return count == 1 ? (future ? "in a week" : "a week ago") : (future ? count + " weeks" : count + " weeks ago");
    }

    protected String getMonthPeriod(int count, boolean future) {
        return count == 1 ? (future ? "a month" : "a month ago") : (future ? count + " months" : count + " months ago");
    }

    protected String getYearPeriod(int count, boolean future) {
        return count == 1 ? (future ? "within a year" : "an year ago") : (future ? count + " years" : count + " years ago");
    }

    public static String period(Date date) {
        return PeriodCounter.period(date, Locale.getDefault());
    }

    public static String period(Date date, Locale locale) {
        PeriodCounter counter = counters.get(locale);
        if (counter != null) {
            return counter.evaluate(date);
        }
        if (locale.getVariant().length() > 0 && (counter = counters.get(locale = new Locale(locale.getLanguage(), locale.getCountry()))) != null) {
            return counter.evaluate(date);
        }
        if (locale.getCountry().length() > 0 && (counter = counters.get(locale = new Locale(locale.getLanguage()))) != null) {
            return counter.evaluate(date);
        }
        return ENGLISH.evaluate(date);
    }

    static {
        counters.put(ENGLISH.getLocale(), ENGLISH);
        counters.put(RUSSIAN.getLocale(), RUSSIAN);
        Iterator<PeriodCounter> itr = Service.lookup(PeriodCounter.class);
        while (itr.hasNext()) {
            PeriodCounter counter = itr.next();
            counters.put(counter.getLocale(), counter);
        }
    }
}

