/*
 * Decompiled with CFR 0.152.
 */
package org.foxlabs.util.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.foxlabs.util.reflect.PropertyAccessException;

public abstract class PropertyGetter {
    public abstract Class<?> getType();

    public abstract Type getGenericType();

    public abstract Object getValue(Object var1);

    public static PropertyGetter newGetter(Member getter) {
        if (getter == null || Modifier.isAbstract(getter.getModifiers())) {
            return null;
        }
        if (getter instanceof java.lang.reflect.Method) {
            return new Method((java.lang.reflect.Method)getter);
        }
        if (getter instanceof java.lang.reflect.Field) {
            return new Field((java.lang.reflect.Field)getter);
        }
        throw new IllegalArgumentException();
    }

    static final class Field
    extends PropertyGetter {
        private final java.lang.reflect.Field field;

        private Field(java.lang.reflect.Field field) {
            field.setAccessible(true);
            this.field = field;
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        @Override
        public Type getGenericType() {
            return this.field.getGenericType();
        }

        @Override
        public Object getValue(Object object) {
            try {
                return this.field.get(object);
            }
            catch (IllegalAccessException e) {
                throw new PropertyAccessException(e);
            }
            catch (IllegalArgumentException e) {
                throw new PropertyAccessException(e);
            }
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Field && ((Field)obj).field.equals(this.field);
        }

        public String toString() {
            return this.field.toGenericString();
        }
    }

    static final class Method
    extends PropertyGetter {
        private final java.lang.reflect.Method method;

        private Method(java.lang.reflect.Method method) {
            method.setAccessible(true);
            this.method = method;
        }

        @Override
        public Class<?> getType() {
            return this.method.getReturnType();
        }

        @Override
        public Type getGenericType() {
            return this.method.getGenericReturnType();
        }

        @Override
        public Object getValue(Object object) {
            try {
                return this.method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new PropertyAccessException(e);
            }
            catch (IllegalArgumentException e) {
                throw new PropertyAccessException(e);
            }
            catch (InvocationTargetException e) {
                throw new PropertyAccessException(e.getTargetException());
            }
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Method && ((Method)obj).method.equals(this.method);
        }

        public String toString() {
            return this.method.toGenericString();
        }
    }
}

