/*
 * Decompiled with CFR 0.152.
 */
package org.foxlabs.util.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.foxlabs.util.reflect.PropertyAccessException;

public abstract class PropertySetter {
    public abstract Class<?> getType();

    public abstract Type getGenericType();

    public abstract void setValue(Object var1, Object var2);

    public static PropertySetter newSetter(Member setter) {
        if (setter == null || Modifier.isAbstract(setter.getModifiers())) {
            return null;
        }
        if (setter instanceof java.lang.reflect.Method) {
            return new Method((java.lang.reflect.Method)setter);
        }
        if (setter instanceof java.lang.reflect.Field) {
            return new Field((java.lang.reflect.Field)setter);
        }
        throw new IllegalArgumentException();
    }

    public static final class Field
    extends PropertySetter {
        private final java.lang.reflect.Field field;

        private Field(java.lang.reflect.Field field) {
            field.setAccessible(true);
            this.field = field;
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        @Override
        public Type getGenericType() {
            return this.field.getGenericType();
        }

        @Override
        public void setValue(Object object, Object value) {
            try {
                this.field.set(object, value);
            }
            catch (IllegalAccessException e) {
                throw new PropertyAccessException(e);
            }
            catch (IllegalArgumentException e) {
                throw new PropertyAccessException(e);
            }
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Field && ((Field)obj).field.equals(this.field);
        }

        public String toString() {
            return this.field.toGenericString();
        }
    }

    public static final class Method
    extends PropertySetter {
        private final java.lang.reflect.Method method;

        private Method(java.lang.reflect.Method method) {
            method.setAccessible(true);
            this.method = method;
        }

        @Override
        public Class<?> getType() {
            return this.method.getParameterTypes()[0];
        }

        @Override
        public Type getGenericType() {
            return this.method.getGenericParameterTypes()[0];
        }

        @Override
        public void setValue(Object object, Object value) {
            try {
                this.method.invoke(object, value);
            }
            catch (IllegalAccessException e) {
                throw new PropertyAccessException(e);
            }
            catch (IllegalArgumentException e) {
                throw new PropertyAccessException(e);
            }
            catch (InvocationTargetException e) {
                throw new PropertyAccessException(e.getTargetException());
            }
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Method && ((Method)obj).method.equals(this.method);
        }

        public String toString() {
            return this.method.toGenericString();
        }
    }
}

