/**
 * Copyright (c) 2018 itemis AG (http://www.itemis.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.franca.deploymodel.core;

import com.google.common.base.Objects;
import org.franca.deploymodel.dsl.fDeploy.FDBuiltInPropertyHost;

/**
 * A property host defines an aspect of a metamodel which can be annotated with
 * deployment properties.</p>
 * 
 * The property host might be either built-in to Franca (referring to concepts
 * from Franca IDL models like method, number, struct, ...) or provided via
 * a deployment extension.</p>
 * 
 * @author: Klaus Birken (itemis AG)
 */
@SuppressWarnings("all")
public class FDPropertyHost {
  private final FDBuiltInPropertyHost builtinHost;
  
  private final String extensionHost;
  
  public static FDPropertyHost builtIn(final FDBuiltInPropertyHost asBuiltin) {
    return new FDPropertyHost(asBuiltin);
  }
  
  public FDPropertyHost(final FDBuiltInPropertyHost asBuiltin) {
    this.builtinHost = asBuiltin;
    this.extensionHost = null;
  }
  
  public FDPropertyHost(final String asExtension) {
    this.builtinHost = null;
    this.extensionHost = asExtension;
  }
  
  public String getName() {
    String _xifexpression = null;
    if ((this.extensionHost != null)) {
      _xifexpression = this.extensionHost;
    } else {
      _xifexpression = this.builtinHost.getName();
    }
    return _xifexpression;
  }
  
  public boolean isBuiltIn(final FDBuiltInPropertyHost type) {
    return ((this.builtinHost != null) && (this.builtinHost == type));
  }
  
  public FDBuiltInPropertyHost getBuiltIn() {
    return this.builtinHost;
  }
  
  @Override
  public boolean equals(final Object other) {
    if ((this == other)) {
      return true;
    }
    if ((other == null)) {
      return false;
    }
    Class<?> _class = other.getClass();
    Class<? extends FDPropertyHost> _class_1 = this.getClass();
    boolean _notEquals = (!Objects.equal(_class, _class_1));
    if (_notEquals) {
      return false;
    }
    final FDPropertyHost cmp = ((FDPropertyHost) other);
    boolean _notEquals_1 = (!Objects.equal(this.builtinHost, cmp.builtinHost));
    if (_notEquals_1) {
      return false;
    }
    boolean _notEquals_2 = (!Objects.equal(this.extensionHost, cmp.extensionHost));
    if (_notEquals_2) {
      return false;
    }
    return true;
  }
  
  @Override
  public int hashCode() {
    int _xblockexpression = (int) 0;
    {
      int result = 17;
      if ((this.builtinHost != null)) {
        int _hashCode = this.builtinHost.getLiteral().hashCode();
        int _plus = ((31 * result) + _hashCode);
        result = _plus;
      }
      if ((this.extensionHost != null)) {
        int _hashCode_1 = this.extensionHost.hashCode();
        int _plus_1 = ((37 * result) + _hashCode_1);
        result = _plus_1;
      }
      _xblockexpression = result;
    }
    return _xblockexpression;
  }
  
  @Override
  public String toString() {
    String _xifexpression = null;
    if ((this.builtinHost != null)) {
      _xifexpression = this.builtinHost.getName();
    } else {
      _xifexpression = (this.extensionHost + "!");
    }
    return _xifexpression;
  }
}
