/**
 * Copyright (c) 2012 itemis AG (http://www.itemis.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.franca.deploymodel.core;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.franca.core.franca.FModel;
import org.franca.core.franca.Import;
import org.franca.core.utils.AbstractFrancaValidator;
import org.franca.deploymodel.dsl.fDeploy.FDModel;

/**
 * Uses Xtext validators of Franca IDL and Franca deployment DSL to validate
 * a Franca resource (*.fidl or *.fdepl). It will validate imported files
 * recursively.
 * 
 * @author Klaus Birken (itemis)
 */
@SuppressWarnings("all")
public class FDeployRecursiveValidator extends AbstractFrancaValidator {
  @Override
  public void validateImportedResources(final Resource resource) {
    final EObject model = resource.getContents().get(0);
    boolean _matched = false;
    if (model instanceof FModel) {
      _matched=true;
      final Function1<Import, String> _function = new Function1<Import, String>() {
        @Override
        public String apply(final Import it) {
          return it.getImportURI();
        }
      };
      this.doValidate(ListExtensions.<Import, String>map(((FModel)model).getImports(), _function), resource.getResourceSet());
    }
    if (!_matched) {
      if (model instanceof FDModel) {
        _matched=true;
        final Function1<org.franca.deploymodel.dsl.fDeploy.Import, String> _function = new Function1<org.franca.deploymodel.dsl.fDeploy.Import, String>() {
          @Override
          public String apply(final org.franca.deploymodel.dsl.fDeploy.Import it) {
            return it.getImportURI();
          }
        };
        this.doValidate(ListExtensions.<org.franca.deploymodel.dsl.fDeploy.Import, String>map(((FDModel)model).getImports(), _function), resource.getResourceSet());
      }
    }
    if (!_matched) {
      String _string = model.toString();
      String _plus = ("Unknown resource content \'" + _string);
      String _plus_1 = (_plus + "\'");
      new Exception(_plus_1);
    }
  }
}
