/**
 * Copyright (c) 2013 itemis AG (http://www.itemis.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.franca.deploymodel.dsl;

import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.formatting.IFormatter;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.impl.ImportUriGlobalScopeProvider;
import org.eclipse.xtext.serializer.tokens.IValueSerializer;
import org.franca.deploymodel.dsl.AbstractFDeployRuntimeModule;
import org.franca.deploymodel.dsl.formatting.FDeployFormatter;
import org.franca.deploymodel.dsl.serializer.FDeployValueSerializer;
import org.franca.deploymodel.dsl.valueconverter.FDeployValueConverters;

/**
 * Use this class to register components to be used at runtime / without the Equinox extension registry.
 */
@SuppressWarnings("all")
public class FDeployRuntimeModule extends AbstractFDeployRuntimeModule {
  @Override
  public Class<? extends IGlobalScopeProvider> bindIGlobalScopeProvider() {
    return ImportUriGlobalScopeProvider.class;
  }
  
  @Override
  public Class<? extends IFormatter> bindIFormatter() {
    return FDeployFormatter.class;
  }
  
  @Override
  public Class<? extends IValueConverterService> bindIValueConverterService() {
    return FDeployValueConverters.class;
  }
  
  public Class<? extends IValueSerializer> bindIValueSerializer() {
    return FDeployValueSerializer.class;
  }
}
