/**
 * Copyright (c) 2013 itemis AG (http://www.itemis.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.franca.deploymodel.dsl;

import com.google.inject.Injector;
import org.eclipse.emf.ecore.EPackage;
import org.franca.core.franca.FrancaPackage;
import org.franca.deploymodel.dsl.FDeployStandaloneSetupGenerated;
import org.franca.deploymodel.dsl.fDeploy.FDeployPackage;

/**
 * Initialization support for running Xtext languages
 * without equinox extension registry
 */
@SuppressWarnings("all")
public class FDeployStandaloneSetup extends FDeployStandaloneSetupGenerated {
  public static void doSetup() {
    new FDeployStandaloneSetup().createInjectorAndDoEMFRegistration();
  }
  
  @Override
  public Injector createInjectorAndDoEMFRegistration() {
    boolean _containsKey = EPackage.Registry.INSTANCE.containsKey("http://core.franca.org");
    boolean _not = (!_containsKey);
    if (_not) {
      EPackage.Registry.INSTANCE.put("http://core.franca.org", FrancaPackage.eINSTANCE);
    }
    return super.createInjectorAndDoEMFRegistration();
  }
  
  @Override
  public void register(final Injector injector) {
    boolean _containsKey = EPackage.Registry.INSTANCE.containsKey("http://www.franca.org/deploymodel/dsl/FDeploy");
    boolean _not = (!_containsKey);
    if (_not) {
      EPackage.Registry.INSTANCE.put("http://www.franca.org/deploymodel/dsl/FDeploy", 
        FDeployPackage.eINSTANCE);
    }
    super.register(injector);
  }
}
