/**
 * Copyright (c) 2015 itemis AG (http://www.itemis.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.franca.deploymodel.dsl.generator.internal;

import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.deploymodel.dsl.fDeploy.FDEnumType;
import org.franca.deploymodel.dsl.fDeploy.FDExtensionType;
import org.franca.deploymodel.dsl.fDeploy.FDModel;
import org.franca.deploymodel.dsl.fDeploy.FDPredefinedTypeId;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;
import org.franca.deploymodel.dsl.fDeploy.FDType;
import org.franca.deploymodel.dsl.fDeploy.FDTypeRef;
import org.franca.deploymodel.extensions.ExtensionRegistry;
import org.franca.deploymodel.extensions.IFDeployExtension;

@SuppressWarnings("all")
public class GeneratorHelper {
  public static String getGetter(final FDTypeRef typeRef) {
    String _xblockexpression = null;
    {
      String _xifexpression = null;
      FDType _complex = typeRef.getComplex();
      boolean _tripleEquals = (_complex == null);
      if (_tripleEquals) {
        String _switchResult = null;
        FDPredefinedTypeId _predefined = typeRef.getPredefined();
        if (_predefined != null) {
          switch (_predefined) {
            case BOOLEAN:
              _switchResult = "Boolean";
              break;
            case INTEGER:
              _switchResult = "Integer";
              break;
            case STRING:
              _switchResult = "String";
              break;
            case INTERFACE:
              _switchResult = "Interface";
              break;
            default:
              break;
          }
        }
        _xifexpression = _switchResult;
      } else {
        String _xblockexpression_1 = null;
        {
          final FDType ct = typeRef.getComplex();
          String _switchResult_1 = null;
          boolean _matched = false;
          if (ct instanceof FDEnumType) {
            _matched=true;
            _switchResult_1 = "Enum";
          }
          if (!_matched) {
            if (ct instanceof FDExtensionType) {
              _matched=true;
              _switchResult_1 = "GenericReference";
            }
          }
          _xblockexpression_1 = _switchResult_1;
        }
        _xifexpression = _xblockexpression_1;
      }
      final String single = _xifexpression;
      String _xifexpression_1 = null;
      String _array = typeRef.getArray();
      boolean _tripleEquals_1 = (_array == null);
      if (_tripleEquals_1) {
        _xifexpression_1 = single;
      } else {
        _xifexpression_1 = (single + "Array");
      }
      _xblockexpression = _xifexpression_1;
    }
    return _xblockexpression;
  }
  
  public static String getExtraArgs(final FDTypeRef typeRef) {
    String _xblockexpression = null;
    {
      final FDType ct = typeRef.getComplex();
      if ((ct != null)) {
        if ((ct instanceof FDExtensionType)) {
          final IFDeployExtension.TypeDef typeDef = ExtensionRegistry.findType(((FDExtensionType)ct).getName());
          StringConcatenation _builder = new StringConcatenation();
          String _simpleName = typeDef.getRuntimeType().getSimpleName();
          _builder.append(_simpleName);
          _builder.append(".class, ");
          return _builder.toString();
        }
      }
      _xblockexpression = "";
    }
    return _xblockexpression;
  }
  
  public static boolean hasEnumType(final FDPropertyDecl decl) {
    boolean _xblockexpression = false;
    {
      final FDType t = decl.getType().getComplex();
      _xblockexpression = ((t != null) && (t instanceof FDEnumType));
    }
    return _xblockexpression;
  }
  
  public static boolean isEnum(final FDPropertyDecl it) {
    return ((it.getType().getComplex() != null) && (it.getType().getComplex() instanceof FDEnumType));
  }
  
  public static CharSequence genListType(final String type) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("List<");
    _builder.append(type);
    _builder.append(">");
    return _builder;
  }
  
  public static CharSequence getMethodName(final FDPropertyDecl it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("get");
    String _firstUpper = StringExtensions.toFirstUpper(it.getName());
    _builder.append(_firstUpper);
    return _builder;
  }
  
  public static String getPackage(final FDSpecification it) {
    String _xblockexpression = null;
    {
      final List<String> parts = CollectionLiterals.<String>newArrayList();
      final FDModel model = EcoreUtil2.<FDModel>getContainerOfType(it, FDModel.class);
      if (((model != null) && (model.getName() != null))) {
        parts.add(model.getName());
      }
      final int sep = it.getName().lastIndexOf(".");
      if ((sep > 0)) {
        parts.add(it.getName().substring(0, sep));
      }
      _xblockexpression = IterableExtensions.join(parts, ".");
    }
    return _xblockexpression;
  }
  
  public static String classname(final FDSpecification it) {
    String _xblockexpression = null;
    {
      final int sep = it.getName().lastIndexOf(".");
      String _xifexpression = null;
      if ((sep > 0)) {
        _xifexpression = it.getName().substring((sep + 1));
      } else {
        _xifexpression = it.getName();
      }
      final String basename = _xifexpression;
      _xblockexpression = StringExtensions.toFirstUpper(basename);
    }
    return _xblockexpression;
  }
  
  public static String getQualifiedClassname(final FDSpecification it) {
    String _xblockexpression = null;
    {
      final String p = GeneratorHelper.getPackage(it);
      String _xifexpression = null;
      boolean _isEmpty = p.isEmpty();
      if (_isEmpty) {
        _xifexpression = GeneratorHelper.classname(it);
      } else {
        String _classname = GeneratorHelper.classname(it);
        _xifexpression = ((p + ".") + _classname);
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
}
