/**
 * Copyright (c) 2015 itemis AG (http://www.itemis.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.franca.deploymodel.dsl.generator.internal;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FArrayType;
import org.franca.core.franca.FField;
import org.franca.deploymodel.dsl.fDeploy.FDEnumType;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;
import org.franca.deploymodel.dsl.generator.internal.AccessMethodGenerator;
import org.franca.deploymodel.dsl.generator.internal.CodeContext;
import org.franca.deploymodel.dsl.generator.internal.GeneratorHelper;
import org.franca.deploymodel.dsl.generator.internal.ImportManager;

@SuppressWarnings("all")
public class IDataGenerator extends AccessMethodGenerator {
  @Inject
  @Extension
  private ImportManager _importManager;
  
  public CharSequence generate(final FDSpecification spec) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Interface for data deployment properties for \'");
    String _name = spec.getName();
    _builder.append(_name, " ");
    _builder.append("\' specification");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* This is the data types related part only.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public interface IDataPropertyAccessor");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("extends Enums");
    {
      FDSpecification _base = spec.getBase();
      boolean _tripleNotEquals = (_base != null);
      if (_tripleNotEquals) {
        _builder.append(", ");
        String _qualifiedClassname = GeneratorHelper.getQualifiedClassname(spec.getBase());
        _builder.append(_qualifiedClassname, "\t");
        _builder.append(".IDataPropertyAccessor");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    CodeContext _codeContext = new CodeContext();
    CharSequence _generateAccessMethods = this.generateAccessMethods(spec, false, _codeContext);
    _builder.append(_generateAccessMethods, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _genHelpForGetOverwriteAccessor = this.genHelpForGetOverwriteAccessor(FField.class, "obj");
    _builder.append(_genHelpForGetOverwriteAccessor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    this._importManager.addNeededFrancaType(FField.class);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public IDataPropertyAccessor getOverwriteAccessor(FField obj);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _genHelpForGetOverwriteAccessor_1 = this.genHelpForGetOverwriteAccessor(FArrayType.class, "obj");
    _builder.append(_genHelpForGetOverwriteAccessor_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    this._importManager.addNeededFrancaType(FArrayType.class);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public IDataPropertyAccessor getOverwriteAccessor(FArrayType obj);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence genMethod(final FDPropertyDecl it, final Class<? extends EObject> francaType, final boolean isData) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    CharSequence _javaType = this._importManager.getJavaType(it.getType());
    _builder.append(_javaType);
    _builder.append(" ");
    CharSequence _methodName = GeneratorHelper.getMethodName(it);
    _builder.append(_methodName);
    _builder.append("(");
    String _simpleName = francaType.getSimpleName();
    _builder.append(_simpleName);
    _builder.append(" obj);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Override
  public CharSequence genEnumMethod(final FDPropertyDecl it, final Class<? extends EObject> francaType, final String enumType, final String returnType, final FDEnumType enumerator, final boolean isData) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    _builder.append(returnType);
    _builder.append(" ");
    CharSequence _methodName = GeneratorHelper.getMethodName(it);
    _builder.append(_methodName);
    _builder.append("(");
    String _simpleName = francaType.getSimpleName();
    _builder.append(_simpleName);
    _builder.append(" obj);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
