/**
 * Copyright (c) 2015 itemis AG (http://www.itemis.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.franca.deploymodel.dsl.generator.internal;

import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.franca.core.franca.FInterface;
import org.franca.deploymodel.dsl.fDeploy.FDEnumType;
import org.franca.deploymodel.dsl.fDeploy.FDExtensionType;
import org.franca.deploymodel.dsl.fDeploy.FDPredefinedTypeId;
import org.franca.deploymodel.dsl.fDeploy.FDType;
import org.franca.deploymodel.dsl.fDeploy.FDTypeRef;
import org.franca.deploymodel.extensions.ExtensionRegistry;
import org.franca.deploymodel.extensions.IFDeployExtension;

@Singleton
@SuppressWarnings("all")
public class ImportManager {
  private Set<Class<? extends EObject>> neededFrancaTypes;
  
  private Set<Class<?>> neededOtherTypes;
  
  private boolean needList;
  
  private boolean needArrayList;
  
  public boolean initImportManager() {
    boolean _xblockexpression = false;
    {
      this.neededFrancaTypes = CollectionLiterals.<Class<? extends EObject>>newHashSet();
      this.neededOtherTypes = CollectionLiterals.<Class<?>>newHashSet();
      this.needList = false;
      _xblockexpression = this.needArrayList = false;
    }
    return _xblockexpression;
  }
  
  public CharSequence getJavaType(final FDTypeRef typeRef) {
    CharSequence _xblockexpression = null;
    {
      String _xifexpression = null;
      FDType _complex = typeRef.getComplex();
      boolean _tripleEquals = (_complex == null);
      if (_tripleEquals) {
        String _switchResult = null;
        FDPredefinedTypeId _predefined = typeRef.getPredefined();
        if (_predefined != null) {
          switch (_predefined) {
            case BOOLEAN:
              _switchResult = "Boolean";
              break;
            case INTEGER:
              _switchResult = "Integer";
              break;
            case STRING:
              _switchResult = "String";
              break;
            case INTERFACE:
              String _xblockexpression_1 = null;
              {
                this.neededFrancaTypes.add(FInterface.class);
                _xblockexpression_1 = "FInterface";
              }
              _switchResult = _xblockexpression_1;
              break;
            default:
              break;
          }
        }
        _xifexpression = _switchResult;
      } else {
        String _xblockexpression_2 = null;
        {
          final FDType ct = typeRef.getComplex();
          String _switchResult_1 = null;
          boolean _matched = false;
          if (ct instanceof FDEnumType) {
            _matched=true;
            _switchResult_1 = "String";
          }
          if (!_matched) {
            if (ct instanceof FDExtensionType) {
              _matched=true;
              String _xblockexpression_3 = null;
              {
                final IFDeployExtension.TypeDef typeDef = ExtensionRegistry.findType(((FDExtensionType)ct).getName());
                final Class<? extends EObject> t = typeDef.getRuntimeType();
                this.neededFrancaTypes.add(t);
                _xblockexpression_3 = t.getSimpleName();
              }
              _switchResult_1 = _xblockexpression_3;
            }
          }
          _xblockexpression_2 = _switchResult_1;
        }
        _xifexpression = _xblockexpression_2;
      }
      final String single = _xifexpression;
      CharSequence _xifexpression_1 = null;
      String _array = typeRef.getArray();
      boolean _tripleEquals_1 = (_array == null);
      if (_tripleEquals_1) {
        _xifexpression_1 = single;
      } else {
        CharSequence _xblockexpression_3 = null;
        {
          this.needList = true;
          _xblockexpression_3 = this.genListType(single);
        }
        _xifexpression_1 = _xblockexpression_3;
      }
      _xblockexpression = _xifexpression_1;
    }
    return _xblockexpression;
  }
  
  public void addNeededFrancaType(final Class<? extends EObject> clazz) {
    this.neededFrancaTypes.add(clazz);
  }
  
  public void addNeededOtherType(final Class<?> clazz) {
    this.neededOtherTypes.add(clazz);
  }
  
  public CharSequence genListType(final String type) {
    CharSequence _xblockexpression = null;
    {
      this.setNeedArrayList();
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("List<");
      _builder.append(type);
      _builder.append(">");
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  public boolean setNeedArrayList() {
    return this.needArrayList = true;
  }
  
  public boolean needList() {
    return this.needList;
  }
  
  public Iterable<String> getNeededFrancaTypes() {
    final Function1<Class<? extends EObject>, String> _function = new Function1<Class<? extends EObject>, String>() {
      @Override
      public String apply(final Class<? extends EObject> it) {
        return it.getSimpleName();
      }
    };
    return IterableExtensions.<Class<? extends EObject>, String>map(this.neededFrancaTypes, _function);
  }
  
  public CharSequence genImports() {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (this.needList) {
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import java.util.ArrayList;");
        _builder.newLine();
      }
    }
    _builder.append("import java.util.Map;");
    _builder.newLine();
    _builder.newLine();
    {
      final Function1<Class<?>, String> _function = new Function1<Class<?>, String>() {
        @Override
        public String apply(final Class<?> it) {
          return it.getCanonicalName();
        }
      };
      List<String> _sort = IterableExtensions.<String>sort(IterableExtensions.<String>filterNull(IterableExtensions.<Class<?>, String>map(Sets.<Class<?>>union(this.neededFrancaTypes, this.neededOtherTypes), _function)));
      for(final String p : _sort) {
        _builder.append("import ");
        _builder.append(p);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("import com.google.common.collect.Maps;");
    _builder.newLine();
    return _builder;
  }
}
