/**
 * Copyright (c) 2018 itemis AG (http://www.itemis.de).
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.franca.deploymodel.dsl.generator.internal;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.deploymodel.core.FDPropertyHost;
import org.franca.deploymodel.core.FDeployedRootElement;
import org.franca.deploymodel.dsl.fDeploy.FDDeclaration;
import org.franca.deploymodel.dsl.fDeploy.FDEnumType;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;
import org.franca.deploymodel.dsl.fDeploy.FDType;
import org.franca.deploymodel.dsl.generator.internal.CodeContext;
import org.franca.deploymodel.dsl.generator.internal.CommonAccessorMethodGenerator;
import org.franca.deploymodel.dsl.generator.internal.GeneratorHelper;
import org.franca.deploymodel.dsl.generator.internal.HostLogic;
import org.franca.deploymodel.dsl.generator.internal.ICodeContext;
import org.franca.deploymodel.dsl.generator.internal.ImportManager;

/**
 * Generates a specific PropertyAccessor class for a root element definition
 * from a deployment extension.</p>
 * 
 * @author Klaus Birken (itemis AG)
 */
@SuppressWarnings("all")
public class RootElementAccessorGenerator {
  @Inject
  @Extension
  private ImportManager _importManager;
  
  @Inject
  private CommonAccessorMethodGenerator helper;
  
  public CharSequence generate(final FDSpecification spec, final Class<? extends EObject> rootClass, final String prefix, final String extensionName, final Function1<? super FDPropertyHost, ? extends Boolean> checkHost) {
    CharSequence _xblockexpression = null;
    {
      final CodeContext context = new CodeContext();
      final String rootTag = StringExtensions.toFirstUpper(prefix);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("FDeployedRootElement<");
      String _simpleName = rootClass.getSimpleName();
      _builder.append(_simpleName);
      _builder.append(">");
      final String deployed = _builder.toString();
      StringConcatenation _builder_1 = new StringConcatenation();
      {
        EList<FDDeclaration> _declarations = spec.getDeclarations();
        for(final FDDeclaration d : _declarations) {
          CharSequence _genProperties = this.genProperties(d, checkHost, context);
          _builder_1.append(_genProperties);
          _builder_1.newLineIfNotEmpty();
        }
      }
      final String methods = _builder_1.toString();
      StringConcatenation _builder_2 = new StringConcatenation();
      _builder_2.append("/**");
      _builder_2.newLine();
      _builder_2.append(" ");
      _builder_2.append("* Accessor for deployment properties for \'");
      _builder_2.append(prefix, " ");
      _builder_2.append("\' roots");
      _builder_2.newLineIfNotEmpty();
      _builder_2.append(" ");
      _builder_2.append("* (which are defined by the \'");
      _builder_2.append(extensionName, " ");
      _builder_2.append("\' extension)");
      _builder_2.newLineIfNotEmpty();
      _builder_2.append(" ");
      _builder_2.append("* according to the \'");
      String _name = spec.getName();
      _builder_2.append(_name, " ");
      _builder_2.append("\' specification.");
      _builder_2.newLineIfNotEmpty();
      _builder_2.append(" ");
      _builder_2.append("*/");
      _builder_2.newLine();
      _builder_2.append("public static class ");
      _builder_2.append(rootTag);
      _builder_2.append("PropertyAccessor");
      _builder_2.newLineIfNotEmpty();
      _builder_2.append("\t");
      {
        FDSpecification _base = spec.getBase();
        boolean _tripleNotEquals = (_base != null);
        if (_tripleNotEquals) {
          _builder_2.append("extends ");
          String _qualifiedClassname = GeneratorHelper.getQualifiedClassname(spec.getBase());
          _builder_2.append(_qualifiedClassname, "\t");
          _builder_2.append(".");
          _builder_2.append(rootTag, "\t");
          _builder_2.append("PropertyAccessor");
        }
      }
      _builder_2.newLineIfNotEmpty();
      _builder_2.append("\t");
      _builder_2.append("implements Enums");
      _builder_2.newLine();
      _builder_2.append("{");
      _builder_2.newLine();
      {
        boolean _isTargetNeeded = context.isTargetNeeded();
        if (_isTargetNeeded) {
          _builder_2.append("\t");
          _builder_2.append("final private ");
          _builder_2.append(deployed, "\t");
          _builder_2.append(" target;");
          _builder_2.newLineIfNotEmpty();
        }
      }
      _builder_2.newLine();
      _builder_2.append("\t");
      this._importManager.addNeededOtherType(FDeployedRootElement.class);
      _builder_2.newLineIfNotEmpty();
      _builder_2.append("\t");
      this._importManager.addNeededFrancaType(rootClass);
      _builder_2.newLineIfNotEmpty();
      _builder_2.append("\t");
      _builder_2.append("public ");
      _builder_2.append(rootTag, "\t");
      _builder_2.append("PropertyAccessor(");
      _builder_2.append(deployed, "\t");
      _builder_2.append(" target) {");
      _builder_2.newLineIfNotEmpty();
      {
        FDSpecification _base_1 = spec.getBase();
        boolean _tripleNotEquals_1 = (_base_1 != null);
        if (_tripleNotEquals_1) {
          _builder_2.append("\t\t");
          _builder_2.append("super(target);");
          _builder_2.newLine();
        }
      }
      {
        boolean _isTargetNeeded_1 = context.isTargetNeeded();
        if (_isTargetNeeded_1) {
          _builder_2.append("\t\t");
          _builder_2.append("this.target = target;");
          _builder_2.newLine();
        }
      }
      _builder_2.append("\t");
      _builder_2.append("}");
      _builder_2.newLine();
      _builder_2.append("\t");
      _builder_2.newLine();
      _builder_2.append("\t");
      _builder_2.append(methods, "\t");
      _builder_2.newLineIfNotEmpty();
      _builder_2.append("}");
      _builder_2.newLine();
      _xblockexpression = _builder_2;
    }
    return _xblockexpression;
  }
  
  private CharSequence genProperties(final FDDeclaration decl, final Function1<? super FDPropertyHost, ? extends Boolean> checkHost, final ICodeContext context) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((decl.getProperties().size() > 0) && (checkHost.apply(decl.getHost())).booleanValue())) {
        _builder.append("// host \'");
        String _name = decl.getHost().getName();
        _builder.append(_name);
        _builder.append("\'");
        _builder.newLineIfNotEmpty();
        {
          EList<FDPropertyDecl> _properties = decl.getProperties();
          for(final FDPropertyDecl p : _properties) {
            CharSequence _genProperty = this.genProperty(p, decl.getHost(), context);
            _builder.append(_genProperty);
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  private CharSequence genProperty(final FDPropertyDecl it, final FDPropertyHost host, final ICodeContext context) {
    CharSequence _xblockexpression = null;
    {
      final Class<? extends EObject> argumentType = HostLogic.getArgumentType(host, HostLogic.Context.NON_FRANCA);
      CharSequence _xifexpression = null;
      if ((argumentType != null)) {
        CharSequence _xblockexpression_1 = null;
        {
          this._importManager.addNeededFrancaType(argumentType);
          context.requireTargetMember();
          CharSequence _xifexpression_1 = null;
          boolean _isEnum = GeneratorHelper.isEnum(it);
          if (_isEnum) {
            CharSequence _xblockexpression_2 = null;
            {
              final String enumType = StringExtensions.toFirstUpper(it.getName());
              String _xifexpression_2 = null;
              String _array = it.getType().getArray();
              boolean _tripleEquals = (_array == null);
              if (_tripleEquals) {
                _xifexpression_2 = enumType;
              } else {
                _xifexpression_2 = this._importManager.genListType(enumType).toString();
              }
              final String retType = _xifexpression_2;
              FDType _complex = it.getType().getComplex();
              final FDEnumType enumerator = ((FDEnumType) _complex);
              _xblockexpression_2 = this.helper.generateEnumMethod(it, argumentType, enumType, retType, enumerator);
            }
            _xifexpression_1 = _xblockexpression_2;
          } else {
            _xifexpression_1 = this.helper.generateMethod(it, argumentType);
          }
          _xblockexpression_1 = _xifexpression_1;
        }
        _xifexpression = _xblockexpression_1;
      } else {
        _xifexpression = "";
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
}
