/**
 * Copyright (c) 2015 itemis AG (http://www.itemis.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.franca.deploymodel.dsl.generator.internal;

import com.google.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FArrayType;
import org.franca.deploymodel.core.FDeployedTypeCollection;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;
import org.franca.deploymodel.dsl.generator.internal.CodeContext;
import org.franca.deploymodel.dsl.generator.internal.CommonAccessorMethodGenerator;
import org.franca.deploymodel.dsl.generator.internal.GeneratorHelper;
import org.franca.deploymodel.dsl.generator.internal.ImportManager;

@SuppressWarnings("all")
public class TypeCollectionAccessorGenerator extends CommonAccessorMethodGenerator {
  @Inject
  @Extension
  private ImportManager _importManager;
  
  public CharSequence generate(final FDSpecification spec) {
    CharSequence _xblockexpression = null;
    {
      final CodeContext context = new CodeContext();
      final CharSequence methods = this.generateAccessMethods(spec, false, context);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* Accessor for deployment properties for Franca type collections according");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* to deployment specification \'");
      String _name = spec.getName();
      _builder.append(_name, " ");
      _builder.append("\'.");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("*/\t\t");
      _builder.newLine();
      _builder.append("public static class TypeCollectionPropertyAccessor");
      _builder.newLine();
      _builder.append("\t");
      {
        FDSpecification _base = spec.getBase();
        boolean _tripleNotEquals = (_base != null);
        if (_tripleNotEquals) {
          _builder.append("extends ");
          String _qualifiedClassname = GeneratorHelper.getQualifiedClassname(spec.getBase());
          _builder.append(_qualifiedClassname, "\t");
          _builder.append(".TypeCollectionPropertyAccessor");
        }
      }
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("implements IDataPropertyAccessor");
      _builder.newLine();
      _builder.append("{");
      _builder.newLine();
      {
        boolean _isTargetNeeded = context.isTargetNeeded();
        if (_isTargetNeeded) {
          _builder.append("\t");
          _builder.append("private final MappingGenericPropertyAccessor target;");
          _builder.newLine();
        }
      }
      _builder.append("\t");
      _builder.append("private final DataPropertyAccessorHelper helper;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      this._importManager.addNeededOtherType(FDeployedTypeCollection.class);
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("public TypeCollectionPropertyAccessor(FDeployedTypeCollection target) {");
      _builder.newLine();
      {
        FDSpecification _base_1 = spec.getBase();
        boolean _tripleNotEquals_1 = (_base_1 != null);
        if (_tripleNotEquals_1) {
          _builder.append("\t\t");
          _builder.append("super(target);");
          _builder.newLine();
        }
      }
      {
        boolean _isTargetNeeded_1 = context.isTargetNeeded();
        if (_isTargetNeeded_1) {
          _builder.append("\t\t");
          _builder.append("this.target = target;");
          _builder.newLine();
        }
      }
      _builder.append("\t\t");
      _builder.append("this.helper = new DataPropertyAccessorHelper(target, this);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.newLine();
      _builder.append("\t");
      _builder.append(methods, "\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public IDataPropertyAccessor getOverwriteAccessor(FField obj) {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("return helper.getOverwriteAccessorAux(obj);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t");
      this._importManager.addNeededFrancaType(FArrayType.class);
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("public IDataPropertyAccessor getOverwriteAccessor(FArrayType obj) {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("return helper.getOverwriteAccessorAux(obj);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
}
