/**
 * Copyright (c) 2012 itemis AG (http://www.itemis.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.franca.deploymodel.dsl.scoping;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.ImportUriGlobalScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.franca.core.FrancaModelExtensions;
import org.franca.core.franca.FArrayType;
import org.franca.core.franca.FBroadcast;
import org.franca.core.franca.FCompoundType;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FMapType;
import org.franca.core.franca.FMethod;
import org.franca.core.franca.FStructType;
import org.franca.core.franca.FType;
import org.franca.core.franca.FTypeDef;
import org.franca.core.franca.FUnionType;
import org.franca.deploymodel.core.FDModelUtils;
import org.franca.deploymodel.core.PropertyMappings;
import org.franca.deploymodel.dsl.fDeploy.FDAbstractExtensionElement;
import org.franca.deploymodel.dsl.fDeploy.FDArgument;
import org.franca.deploymodel.dsl.fDeploy.FDArgumentList;
import org.franca.deploymodel.dsl.fDeploy.FDArray;
import org.franca.deploymodel.dsl.fDeploy.FDAttribute;
import org.franca.deploymodel.dsl.fDeploy.FDBroadcast;
import org.franca.deploymodel.dsl.fDeploy.FDCompoundOverwrites;
import org.franca.deploymodel.dsl.fDeploy.FDElement;
import org.franca.deploymodel.dsl.fDeploy.FDEnumType;
import org.franca.deploymodel.dsl.fDeploy.FDEnumValue;
import org.franca.deploymodel.dsl.fDeploy.FDEnumeration;
import org.franca.deploymodel.dsl.fDeploy.FDEnumerationOverwrites;
import org.franca.deploymodel.dsl.fDeploy.FDExtensionElement;
import org.franca.deploymodel.dsl.fDeploy.FDExtensionRoot;
import org.franca.deploymodel.dsl.fDeploy.FDExtensionType;
import org.franca.deploymodel.dsl.fDeploy.FDField;
import org.franca.deploymodel.dsl.fDeploy.FDInterface;
import org.franca.deploymodel.dsl.fDeploy.FDMap;
import org.franca.deploymodel.dsl.fDeploy.FDMapKey;
import org.franca.deploymodel.dsl.fDeploy.FDMapValue;
import org.franca.deploymodel.dsl.fDeploy.FDMethod;
import org.franca.deploymodel.dsl.fDeploy.FDModel;
import org.franca.deploymodel.dsl.fDeploy.FDOverwriteElement;
import org.franca.deploymodel.dsl.fDeploy.FDProperty;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyFlag;
import org.franca.deploymodel.dsl.fDeploy.FDRootElement;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;
import org.franca.deploymodel.dsl.fDeploy.FDStruct;
import org.franca.deploymodel.dsl.fDeploy.FDType;
import org.franca.deploymodel.dsl.fDeploy.FDTypeOverwrites;
import org.franca.deploymodel.dsl.fDeploy.FDTypeRef;
import org.franca.deploymodel.dsl.fDeploy.FDTypedef;
import org.franca.deploymodel.dsl.fDeploy.FDTypes;
import org.franca.deploymodel.dsl.fDeploy.FDUnion;
import org.franca.deploymodel.dsl.fDeploy.FDeployPackage;
import org.franca.deploymodel.dsl.fDeploy.Import;
import org.franca.deploymodel.dsl.scoping.DeploySpecProvider;
import org.franca.deploymodel.dsl.scoping.FTypeCollectionScope;
import org.franca.deploymodel.extensions.ExtensionRegistry;
import org.franca.deploymodel.extensions.IFDeployExtension;

@SuppressWarnings("all")
public class FDeployScopeProvider extends AbstractDeclarativeScopeProvider {
  @Inject
  private IQualifiedNameProvider qualifiedNameProvider;
  
  @Inject
  private ImportUriGlobalScopeProvider importUriGlobalScopeProvider;
  
  @Inject
  private DeploySpecProvider deploySpecProvider;
  
  @Inject
  private IQualifiedNameConverter qnConverter;
  
  public SimpleScope scope_FDRootElement_spec(final EObject ctxt, final EReference ref) {
    return this.joinImportedDeploySpecs(this.delegateGetScope(ctxt, ref), ctxt);
  }
  
  public SimpleScope scope_FDSpecification_base(final EObject ctxt, final EReference ref) {
    return this.joinImportedDeploySpecs(this.delegateGetScope(ctxt, ref), ctxt);
  }
  
  /**
   * Evaluates the importedAliases of the FDModel containing the <i>ctxt</i>
   * and adds the belonging <i>FDSpecification</i>s to the given scope.
   */
  public SimpleScope joinImportedDeploySpecs(final IScope scope, final EObject ctxt) {
    final FDModel model = EcoreUtil2.<FDModel>getContainerOfType(ctxt, FDModel.class);
    final Function1<Import, Boolean> _function = new Function1<Import, Boolean>() {
      @Override
      public Boolean apply(final Import it) {
        String _importedSpec = it.getImportedSpec();
        return Boolean.valueOf((_importedSpec != null));
      }
    };
    final Function1<Import, String> _function_1 = new Function1<Import, String>() {
      @Override
      public String apply(final Import it) {
        return it.getImportedSpec();
      }
    };
    final Iterable<String> importedAliases = IterableExtensions.<Import, String>map(IterableExtensions.<Import>filter(model.getImports(), _function), _function_1);
    final List<IEObjectDescription> fdSpecsScopeImports = CollectionLiterals.<IEObjectDescription>newArrayList();
    try {
      for (final String a : importedAliases) {
        {
          final DeploySpecProvider.DeploySpecEntry entry = this.deploySpecProvider.getEntry(a);
          FDSpecification _fDSpecification = null;
          if (entry!=null) {
            _fDSpecification=entry.getFDSpecification();
          }
          boolean _tripleNotEquals = (_fDSpecification != null);
          if (_tripleNotEquals) {
            QualifiedName _qualifiedName = this.qnConverter.toQualifiedName(a);
            FDSpecification _fDSpecification_1 = entry.getFDSpecification();
            EObjectDescription _eObjectDescription = new EObjectDescription(_qualifiedName, _fDSpecification_1, null);
            fdSpecsScopeImports.add(_eObjectDescription);
          }
        }
      }
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return new SimpleScope(scope, fdSpecsScopeImports, false);
  }
  
  public IScope scope_FDAbstractExtensionElement_target(final FDAbstractExtensionElement ctxt, final EReference ref) {
    IScope _xblockexpression = null;
    {
      final IFDeployExtension.AbstractElementDef elemDef = ExtensionRegistry.getElement(ctxt);
      IScope _xifexpression = null;
      EClass _targetClass = elemDef.getTargetClass();
      boolean _tripleEquals = (_targetClass == null);
      if (_tripleEquals) {
        _xifexpression = IScope.NULLSCOPE;
      } else {
        FilteringScope _xblockexpression_1 = null;
        {
          final FDExtensionRoot root = EcoreUtil2.<FDExtensionRoot>getContainerOfType(ctxt, FDExtensionRoot.class);
          final IScope delegate = this.delegateGetScope(root, ref);
          final Predicate<IEObjectDescription> _function = new Predicate<IEObjectDescription>() {
            @Override
            public boolean apply(final IEObjectDescription it) {
              return EcoreUtil2.isAssignableFrom(elemDef.getTargetClass(), it.getEClass());
            }
          };
          _xblockexpression_1 = new FilteringScope(delegate, _function);
        }
        _xifexpression = _xblockexpression_1;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public FTypeCollectionScope scope_FDTypes_target(final FDTypes ctxt, final EReference ref) {
    Resource _eResource = ctxt.eResource();
    return new FTypeCollectionScope(IScope.NULLSCOPE, false, this.importUriGlobalScopeProvider, _eResource, this.qualifiedNameProvider);
  }
  
  public IScope scope_FDArray_target(final FDTypes ctxt, final EReference ref) {
    return this.getScopes(ctxt, FArrayType.class);
  }
  
  public IScope scope_FDStruct_target(final FDTypes ctxt, final EReference ref) {
    return this.getScopes(ctxt, FStructType.class);
  }
  
  public IScope scope_FDUnion_target(final FDTypes ctxt, final EReference ref) {
    return this.getScopes(ctxt, FUnionType.class);
  }
  
  public IScope scope_FDEnumeration_target(final FDTypes ctxt, final EReference ref) {
    return this.getScopes(ctxt, FEnumerationType.class);
  }
  
  public IScope scope_FDMap_target(final FDTypes ctxt, final EReference ref) {
    return this.getScopes(ctxt, FMapType.class);
  }
  
  public IScope scope_FDTypedef_target(final FDTypes ctxt, final EReference ref) {
    return this.getScopes(ctxt, FTypeDef.class);
  }
  
  private IScope getScopes(final FDTypes ctxt, final Class<? extends EObject> clazz) {
    return Scopes.scopeFor(Iterables.filter(ctxt.getTarget().getTypes(), clazz));
  }
  
  public IScope scope_FDAttribute_target(final FDInterface ctxt, final EReference ref) {
    return Scopes.scopeFor(ctxt.getTarget().getAttributes());
  }
  
  public IScope scope_FDMethod_target(final FDInterface ctxt, final EReference ref) {
    final Function<FMethod, QualifiedName> _function = new Function<FMethod, QualifiedName>() {
      @Override
      public QualifiedName apply(final FMethod it) {
        return QualifiedName.create(FrancaModelExtensions.getUniqueName(it));
      }
    };
    return Scopes.<FMethod>scopeFor(ctxt.getTarget().getMethods(), _function, 
      IScope.NULLSCOPE);
  }
  
  public IScope scope_FDBroadcast_target(final FDInterface ctxt, final EReference ref) {
    final Function<FBroadcast, QualifiedName> _function = new Function<FBroadcast, QualifiedName>() {
      @Override
      public QualifiedName apply(final FBroadcast it) {
        return QualifiedName.create(FrancaModelExtensions.getUniqueName(it));
      }
    };
    return Scopes.<FBroadcast>scopeFor(ctxt.getTarget().getBroadcasts(), _function, 
      IScope.NULLSCOPE);
  }
  
  public IScope scope_FDArray_target(final FDInterface ctxt, final EReference ref) {
    return this.getScopes(ctxt, FArrayType.class);
  }
  
  public IScope scope_FDStruct_target(final FDInterface ctxt, final EReference ref) {
    return this.getScopes(ctxt, FStructType.class);
  }
  
  public IScope scope_FDUnion_target(final FDInterface ctxt, final EReference ref) {
    return this.getScopes(ctxt, FUnionType.class);
  }
  
  public IScope scope_FDEnumeration_target(final FDInterface ctxt, final EReference ref) {
    return this.getScopes(ctxt, FEnumerationType.class);
  }
  
  public IScope scope_FDTypedef_target(final FDInterface ctxt, final EReference ref) {
    return this.getScopes(ctxt, FTypeDef.class);
  }
  
  private IScope getScopes(final FDInterface ctxt, final Class<? extends EObject> clazz) {
    return Scopes.scopeFor(Iterables.filter(ctxt.getTarget().getTypes(), clazz));
  }
  
  public IScope scope_FDArgument_target(final FDArgumentList ctxt, final EReference ref) {
    IScope _xblockexpression = null;
    {
      final EObject owner = ctxt.eContainer();
      IScope _switchResult = null;
      boolean _matched = false;
      if (owner instanceof FDMethod) {
        _matched=true;
        IScope _xifexpression = null;
        FDArgumentList _inArguments = ((FDMethod)owner).getInArguments();
        boolean _equals = Objects.equal(ctxt, _inArguments);
        if (_equals) {
          _xifexpression = Scopes.scopeFor(((FDMethod)owner).getTarget().getInArgs());
        } else {
          _xifexpression = Scopes.scopeFor(((FDMethod)owner).getTarget().getOutArgs());
        }
        _switchResult = _xifexpression;
      }
      if (!_matched) {
        if (owner instanceof FDBroadcast) {
          _matched=true;
          _switchResult = Scopes.scopeFor(((FDBroadcast)owner).getTarget().getOutArgs());
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  public IScope scope_FDArgument_target(final FDBroadcast ctxt, final EReference ref) {
    return Scopes.scopeFor(ctxt.getTarget().getOutArgs());
  }
  
  public IScope scope_FDField_target(final FDStruct ctxt, final EReference ref) {
    return Scopes.scopeFor(ctxt.getTarget().getElements());
  }
  
  public IScope scope_FDField_target(final FDUnion ctxt, final EReference ref) {
    return Scopes.scopeFor(ctxt.getTarget().getElements());
  }
  
  /**
   * Compute the target elements (of type FField) for a given FDField,
   * if the FDField is a child of a FDCompoundOverwrites section.</p>
   * 
   * I.e., ctxt will be either a struct overwrite section or a union
   * overwrite section. The actual available fields depend on the
   * Franca type of the target element of the overwrite section's parent.
   */
  public IScope scope_FDField_target(final FDCompoundOverwrites ctxt, final EReference ref) {
    IScope _xblockexpression = null;
    {
      EObject _eContainer = ctxt.eContainer();
      final FDOverwriteElement parent = ((FDOverwriteElement) _eContainer);
      final FType type = FDModelUtils.getOverwriteTargetType(parent);
      if ((type != null)) {
        if ((type instanceof FCompoundType)) {
          return Scopes.scopeFor(((FCompoundType)type).getElements());
        }
      }
      _xblockexpression = IScope.NULLSCOPE;
    }
    return _xblockexpression;
  }
  
  public IScope scope_FDEnumValue_target(final FDEnumeration ctxt, final EReference ref) {
    return Scopes.scopeFor(ctxt.getTarget().getEnumerators());
  }
  
  /**
   * Compute the target elements (of type FEnumValue) for a given FDEnumValue,
   * if the FDEnumValue is a child of a FDEnumerationOverwrites section.</p>
   * 
   * The actual available enumerators depend on the Franca type of the
   * target element of the overwrite section's parent.
   */
  public IScope scope_FDEnumValue_target(final FDEnumerationOverwrites ctxt, final EReference ref) {
    IScope _xblockexpression = null;
    {
      EObject _eContainer = ctxt.eContainer();
      final FDOverwriteElement parent = ((FDOverwriteElement) _eContainer);
      final FType type = FDModelUtils.getOverwriteTargetType(parent);
      if ((type != null)) {
        if ((type instanceof FEnumerationType)) {
          return Scopes.scopeFor(((FEnumerationType)type).getEnumerators());
        }
      }
      _xblockexpression = IScope.NULLSCOPE;
    }
    return _xblockexpression;
  }
  
  public IScope scope_FDMap_target(final FDInterface ctxt, final EReference ref) {
    return this.getScopes(ctxt, FMapType.class);
  }
  
  /**
   * Define scope for use-attribute of deployed type collections.</p>
   * 
   * Type collection deployments may only use other type collection deployments.</p>
   */
  public IScope scope_FDRootElement_use(final FDTypes elem, final EReference ref) {
    FilteringScope _xblockexpression = null;
    {
      final IScope delegateScope = this.delegateGetScope(elem, ref);
      final Predicate<IEObjectDescription> _function = new Predicate<IEObjectDescription>() {
        @Override
        public boolean apply(final IEObjectDescription it) {
          return EcoreUtil2.isAssignableFrom(FDeployPackage.eINSTANCE.getFDTypes(), it.getEClass());
        }
      };
      _xblockexpression = new FilteringScope(delegateScope, _function);
    }
    return _xblockexpression;
  }
  
  /**
   * Define scope for use-attribute of deployed interfaces.</p>
   * 
   * Interface deployments may only use type collection deployments
   * and other interface deployments.</p>
   */
  public IScope scope_FDRootElement_use(final FDInterface elem, final EReference ref) {
    FilteringScope _xblockexpression = null;
    {
      final IScope delegateScope = this.delegateGetScope(elem, ref);
      final Predicate<IEObjectDescription> _function = new Predicate<IEObjectDescription>() {
        @Override
        public boolean apply(final IEObjectDescription it) {
          return (EcoreUtil2.isAssignableFrom(FDeployPackage.eINSTANCE.getFDTypes(), it.getEClass()) || 
            EcoreUtil2.isAssignableFrom(FDeployPackage.eINSTANCE.getFDInterface(), it.getEClass()));
        }
      };
      _xblockexpression = new FilteringScope(delegateScope, _function);
    }
    return _xblockexpression;
  }
  
  /**
   * Checks if two deployment definition roots have compatible specifications.</p>
   * 
   * Compatibility means either both parent and child elements reference the
   * same specification or the child's specification is derived from the
   * parent's specification.</p>
   * 
   * As derived DSLs may use some extended logic for retrieving the specification
   * for a root element, this can be configured by providing a function argument.</p>
   */
  protected boolean haveCompatibleSpecs(final FDRootElement parent, final FDRootElement child, final Function1<? super FDRootElement, ? extends FDSpecification> specGetter) {
    boolean _xblockexpression = false;
    {
      final FDSpecification parentSpec = specGetter.apply(parent);
      FDSpecification check = specGetter.apply(child);
      while ((check != null)) {
        {
          boolean _equals = Objects.equal(parentSpec, check);
          if (_equals) {
            return true;
          }
          check = check.getBase();
        }
      }
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  public IScope scope_FDProperty_decl(final FDExtensionRoot owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDExtensionElement owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDInterface owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDTypes owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDAttribute owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDMethod owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDBroadcast owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDArgument owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDArray owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDStruct owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDUnion owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDField owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDEnumeration owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDEnumValue owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDMap owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDMapKey owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDMapValue owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  public IScope scope_FDProperty_decl(final FDTypedef owner, final EReference ref) {
    return this.getPropertyDecls(owner);
  }
  
  /**
   * The properties of an overwrite section are determined by the
   * Franca type of the parent element (i.e., container element in
   * the deployment definition model hierarchy).</p>
   * 
   * Example: In a FDStructOverwrites section, the parent element
   * might be for example a FDAttribute. Validation will ensure that
   * the Franca type of the FDAttribute target (which is an FAttribute)
   * is an FStructType. Thus, the properties we are looking for here
   * are all struct-related properties from the deployment specification.</p>
   */
  public IScope scope_FDProperty_decl(final FDTypeOverwrites owner, final EReference ref) {
    IScope _xblockexpression = null;
    {
      EObject _eContainer = owner.eContainer();
      final FDOverwriteElement parent = ((FDOverwriteElement) _eContainer);
      final FType type = FDModelUtils.getOverwriteTargetType(parent);
      IScope _xifexpression = null;
      if ((type != null)) {
        _xifexpression = this.getPropertyDecls(parent, type);
      } else {
        _xifexpression = IScope.NULLSCOPE;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  private IScope getPropertyDecls(final FDElement elem) {
    IScope _xblockexpression = null;
    {
      final FDRootElement root = FDModelUtils.getRootElement(elem);
      _xblockexpression = Scopes.scopeFor(PropertyMappings.getAllPropertyDecls(root.getSpec(), elem));
    }
    return _xblockexpression;
  }
  
  private IScope getPropertyDecls(final FDElement some, final FType elem) {
    IScope _xblockexpression = null;
    {
      final FDRootElement root = FDModelUtils.getRootElement(some);
      _xblockexpression = Scopes.scopeFor(PropertyMappings.getAllPropertyDecls(root.getSpec(), elem));
    }
    return _xblockexpression;
  }
  
  public IScope scope_FDGeneric_value(final FDPropertyFlag elem, final EReference ref) {
    IScope _xblockexpression = null;
    {
      EObject _eContainer = elem.eContainer();
      final FDPropertyDecl decl = ((FDPropertyDecl) _eContainer);
      _xblockexpression = this.getPropertyDeclGenericScopes(decl, decl, ref);
    }
    return _xblockexpression;
  }
  
  public IScope scope_FDGeneric_value(final FDProperty elem, final EReference ref) {
    return this.getPropertyDeclGenericScopes(elem.getDecl(), elem, ref);
  }
  
  private IScope getPropertyDeclGenericScopes(final FDPropertyDecl decl, final EObject ctxt, final EReference ref) {
    IScope _xblockexpression = null;
    {
      final FDTypeRef typeRef = decl.getType();
      FDType _complex = typeRef.getComplex();
      boolean _tripleNotEquals = (_complex != null);
      if (_tripleNotEquals) {
        final FDType type = typeRef.getComplex();
        if ((type instanceof FDEnumType)) {
          return Scopes.scopeFor(((FDEnumType)type).getEnumerators());
        } else {
          if ((type instanceof FDExtensionType)) {
            final IFDeployExtension.TypeDef typeDef = ExtensionRegistry.findType(((FDExtensionType)type).getName());
            final IScope delegate = this.delegateGetScope(ctxt, ref);
            return typeDef.getScope(delegate);
          }
        }
      }
      _xblockexpression = IScope.NULLSCOPE;
    }
    return _xblockexpression;
  }
}
