/**
 * Copyright (c) 2018 itemis AG (http://www.itemis.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.franca.deploymodel.extensions;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.franca.core.franca.FrancaPackage;
import org.franca.deploymodel.dsl.fDeploy.FDeployPackage;
import org.franca.deploymodel.extensions.IFDeployExtension;

/**
 * Abstract base class for deployment extension implementations.
 * 
 * @author Klaus Birken (itemis AG)
 */
@SuppressWarnings("all")
public abstract class AbstractFDeployExtension implements IFDeployExtension {
  /**
   * Empty default implementation of interface method.</p>
   */
  @Override
  public Collection<IFDeployExtension.RootDef> getRoots() {
    return Collections.<IFDeployExtension.RootDef>unmodifiableList(CollectionLiterals.<IFDeployExtension.RootDef>newArrayList());
  }
  
  /**
   * Empty default implementation of interface method.</p>
   */
  @Override
  public Collection<IFDeployExtension.HostMixinDef> getMixins() {
    return Collections.<IFDeployExtension.HostMixinDef>unmodifiableList(CollectionLiterals.<IFDeployExtension.HostMixinDef>newArrayList());
  }
  
  /**
   * Empty default implementation of interface method.</p>
   */
  @Override
  public Collection<IFDeployExtension.TypeDef> getTypes() {
    return Collections.<IFDeployExtension.TypeDef>unmodifiableList(CollectionLiterals.<IFDeployExtension.TypeDef>newArrayList());
  }
  
  /**
   * Helper to easily access elements of Franca IDL EMF package.</p>
   */
  protected FrancaPackage fidl() {
    return FrancaPackage.eINSTANCE;
  }
  
  /**
   * Helper to easily access elements of Franca Deployment EMF package.</p>
   */
  protected FDeployPackage fdeploy() {
    return FDeployPackage.eINSTANCE;
  }
  
  /**
   * Helper to create a new HostMixinDef descriptor.
   */
  protected IFDeployExtension.HostMixinDef mixin(final EClass clazz, final IFDeployExtension.HostMixinDef.AccessorArgumentStyle argStyle, final Collection<IFDeployExtension.Host> hosts) {
    return new IFDeployExtension.HostMixinDef(clazz, argStyle, hosts);
  }
  
  /**
   * Helper to create a new HostMixinDef descriptor.
   * 
   * @param accessorPrefix prefix for property accessor class name, or CHILD_ELEMENT if this mixin
   *                       should be added to other property accessor based on class hierarchy
   */
  protected IFDeployExtension.HostMixinDef mixin(final EClass clazz, final IFDeployExtension.HostMixinDef.AccessorArgumentStyle argStyle, final String accessorPrefix, final Collection<IFDeployExtension.Host> hosts) {
    return new IFDeployExtension.HostMixinDef(clazz, argStyle, accessorPrefix, hosts);
  }
}
