/**
 * Copyright (c) 2018 itemis AG (http://www.itemis.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.franca.deploymodel.extensions;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.franca.deploymodel.extensions.IFDeployExtension;

@SuppressWarnings("all")
public class ExtensionUtils {
  /**
   * Get all hosts defined by a deployment extension.</p>
   */
  public static Set<IFDeployExtension.Host> getAllHosts(final IFDeployExtension ext) {
    final Function1<IFDeployExtension.RootDef, Iterable<IFDeployExtension.Host>> _function = new Function1<IFDeployExtension.RootDef, Iterable<IFDeployExtension.Host>>() {
      @Override
      public Iterable<IFDeployExtension.Host> apply(final IFDeployExtension.RootDef it) {
        return ExtensionUtils.getAllHostsAux(it);
      }
    };
    final Function1<IFDeployExtension.HostMixinDef, Collection<IFDeployExtension.Host>> _function_1 = new Function1<IFDeployExtension.HostMixinDef, Collection<IFDeployExtension.Host>>() {
      @Override
      public Collection<IFDeployExtension.Host> apply(final IFDeployExtension.HostMixinDef it) {
        return it.getHosts();
      }
    };
    return IterableExtensions.<IFDeployExtension.Host>toSet(Iterables.<IFDeployExtension.Host>concat(
      Iterables.<IFDeployExtension.Host>concat(IterableExtensions.<IFDeployExtension.RootDef, Iterable<IFDeployExtension.Host>>map(ext.getRoots(), _function)), 
      Iterables.<IFDeployExtension.Host>concat(IterableExtensions.<IFDeployExtension.HostMixinDef, Collection<IFDeployExtension.Host>>map(ext.getMixins(), _function_1))));
  }
  
  /**
   * Get the set of all hosts only for an element's children and their subtrees.<p>
   */
  public static Set<IFDeployExtension.Host> getHostsOnlyInSubtree(final IFDeployExtension.AbstractElementDef elem) {
    return IterableExtensions.<IFDeployExtension.Host>toSet(ExtensionUtils.getHostsOnlyInSubtreeAux(elem));
  }
  
  /**
   * Get the set of all hosts relevant for an element or its element subtree.</p>
   */
  public static Set<IFDeployExtension.Host> getAllHosts(final IFDeployExtension.AbstractElementDef elem) {
    return IterableExtensions.<IFDeployExtension.Host>toSet(ExtensionUtils.getAllHostsAux(elem));
  }
  
  /**
   * Helper: Get all hosts only for an element's children and their subtrees.<p>
   */
  private static Iterable<IFDeployExtension.Host> getHostsOnlyInSubtreeAux(final IFDeployExtension.AbstractElementDef elem) {
    final Function1<IFDeployExtension.ElementDef, Iterable<IFDeployExtension.Host>> _function = new Function1<IFDeployExtension.ElementDef, Iterable<IFDeployExtension.Host>>() {
      @Override
      public Iterable<IFDeployExtension.Host> apply(final IFDeployExtension.ElementDef it) {
        return ExtensionUtils.getAllHostsAux(it);
      }
    };
    return Iterables.<IFDeployExtension.Host>concat(IterableExtensions.<IFDeployExtension.ElementDef, Iterable<IFDeployExtension.Host>>map(elem.getChildren(), _function));
  }
  
  /**
   * Helper: Get all hosts relevant for an element or its element subtree.</p>
   */
  private static Iterable<IFDeployExtension.Host> getAllHostsAux(final IFDeployExtension.AbstractElementDef elem) {
    return Iterables.<IFDeployExtension.Host>concat(
      elem.getHosts(), 
      ExtensionUtils.getHostsOnlyInSubtreeAux(elem));
  }
}
