/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.franca.core.franca.FInterface;
import org.franca.deploymodel.core.FDModelUtils;
import org.franca.deploymodel.core.PropertyMappings;
import org.franca.deploymodel.dsl.fDeploy.FDBoolean;
import org.franca.deploymodel.dsl.fDeploy.FDComplexValue;
import org.franca.deploymodel.dsl.fDeploy.FDElement;
import org.franca.deploymodel.dsl.fDeploy.FDEnumerator;
import org.franca.deploymodel.dsl.fDeploy.FDInteger;
import org.franca.deploymodel.dsl.fDeploy.FDInterfaceRef;
import org.franca.deploymodel.dsl.fDeploy.FDProperty;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyFlag;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;
import org.franca.deploymodel.dsl.fDeploy.FDString;
import org.franca.deploymodel.dsl.fDeploy.FDTypeOverwrites;
import org.franca.deploymodel.dsl.fDeploy.FDValue;
import org.franca.deploymodel.dsl.fDeploy.FDValueArray;

public class GenericPropertyAccessor {
    private final FDSpecification spec;

    public GenericPropertyAccessor(FDSpecification spec) {
        this.spec = spec;
    }

    public Boolean getBoolean(FDElement elem, String property) {
        FDValue val = this.getSingleValue(elem, property);
        if (val != null && val instanceof FDBoolean) {
            return ((FDBoolean)val).getValue().equals("true");
        }
        return null;
    }

    public List<Boolean> getBooleanArray(FDElement elem, String property) {
        FDValueArray valarray = this.getValueArray(elem, property);
        if (valarray == null) {
            return null;
        }
        ArrayList vals = Lists.newArrayList();
        for (FDValue v : valarray.getValues()) {
            if (v instanceof FDBoolean) {
                vals.add(((FDBoolean)v).getValue().equals("true"));
                continue;
            }
            return null;
        }
        return vals;
    }

    public Integer getInteger(FDElement elem, String property) {
        FDValue val = this.getSingleValue(elem, property);
        if (val != null && val instanceof FDInteger) {
            return ((FDInteger)val).getValue();
        }
        return null;
    }

    public List<Integer> getIntegerArray(FDElement elem, String property) {
        FDValueArray valarray = this.getValueArray(elem, property);
        if (valarray == null) {
            return null;
        }
        ArrayList vals = Lists.newArrayList();
        for (FDValue v : valarray.getValues()) {
            if (v instanceof FDInteger) {
                vals.add(((FDInteger)v).getValue());
                continue;
            }
            return null;
        }
        return vals;
    }

    public String getString(FDElement elem, String property) {
        FDValue val = this.getSingleValue(elem, property);
        if (val != null && val instanceof FDString) {
            return ((FDString)val).getValue();
        }
        return null;
    }

    public List<String> getStringArray(FDElement elem, String property) {
        FDValueArray valarray = this.getValueArray(elem, property);
        if (valarray == null) {
            return null;
        }
        ArrayList vals = Lists.newArrayList();
        for (FDValue v : valarray.getValues()) {
            if (v instanceof FDString) {
                vals.add(((FDString)v).getValue());
                continue;
            }
            return null;
        }
        return vals;
    }

    public FInterface getInterface(FDElement elem, String property) {
        FDValue val = this.getSingleValue(elem, property);
        if (val != null && val instanceof FDInterfaceRef) {
            return ((FDInterfaceRef)val).getValue();
        }
        return null;
    }

    public List<FInterface> getInterfaceArray(FDElement elem, String property) {
        FDValueArray valarray = this.getValueArray(elem, property);
        if (valarray == null) {
            return null;
        }
        ArrayList vals = Lists.newArrayList();
        for (FDValue v : valarray.getValues()) {
            if (v instanceof FDInterfaceRef) {
                vals.add(((FDInterfaceRef)v).getValue());
                continue;
            }
            return null;
        }
        return vals;
    }

    public <RuntimeType extends EObject> RuntimeType getGenericReference(FDElement elem, Class<? extends EObject> runtimeType, String property) {
        EObject ref;
        FDValue val = this.getSingleValue(elem, property);
        if (val != null && (ref = FDModelUtils.getGenericRef(val)) != null && runtimeType.isInstance(ref)) {
            return (RuntimeType)ref;
        }
        return null;
    }

    public <RuntimeType extends EObject> List<RuntimeType> getGenericReferenceArray(FDElement elem, Class<? extends EObject> runtimeType, String property) {
        FDValueArray valarray = this.getValueArray(elem, property);
        if (valarray == null) {
            return null;
        }
        ArrayList vals = Lists.newArrayList();
        for (FDValue v : valarray.getValues()) {
            EObject ref = FDModelUtils.getGenericRef(v);
            if (ref == null || !runtimeType.isInstance(ref)) continue;
            vals.add(ref);
        }
        return vals;
    }

    public String getEnum(FDElement elem, String property) {
        FDValue val = this.getSingleValue(elem, property);
        if (val != null && FDModelUtils.isEnumerator(val)) {
            return FDModelUtils.getEnumerator(val).getName();
        }
        return null;
    }

    public List<String> getEnumArray(FDElement elem, String property) {
        FDValueArray valarray = this.getValueArray(elem, property);
        if (valarray == null) {
            return null;
        }
        ArrayList vals = Lists.newArrayList();
        for (FDValue v : valarray.getValues()) {
            if (FDModelUtils.isEnumerator(v)) {
                FDEnumerator e = FDModelUtils.getEnumerator(v);
                vals.add(e.getName());
                continue;
            }
            return null;
        }
        return vals;
    }

    private FDValue getSingleValue(FDElement elem, String property) {
        FDComplexValue val = this.getValue(elem, property);
        if (val != null) {
            return val.getSingle();
        }
        return null;
    }

    private FDValueArray getValueArray(FDElement elem, String property) {
        FDComplexValue val = this.getValue(elem, property);
        if (val != null) {
            return val.getArray();
        }
        return null;
    }

    private FDComplexValue getValue(FDElement elem, String property) {
        if (elem.getProperties() != null) {
            for (FDProperty prop : elem.getProperties().getItems()) {
                if (!prop.getDecl().getName().equals(property)) continue;
                return prop.getValue();
            }
            if (GenericPropertyAccessor.isOverwrite(elem)) {
                return null;
            }
        }
        List<FDPropertyDecl> decls = PropertyMappings.getAllPropertyDecls(this.spec, elem);
        for (FDPropertyDecl decl : decls) {
            FDComplexValue dflt;
            if (!decl.getName().equals(property) || (dflt = GenericPropertyAccessor.getDefault(decl)) == null) continue;
            return dflt;
        }
        return null;
    }

    private static boolean isOverwrite(FDElement elem) {
        FDElement e = elem;
        while (e != null) {
            if ((e = e.eContainer()) == null || !(e instanceof FDTypeOverwrites)) continue;
            return true;
        }
        return false;
    }

    public static FDComplexValue getDefault(FDPropertyDecl decl) {
        for (FDPropertyFlag flag : decl.getFlags()) {
            if (flag.getDefault() == null) continue;
            return flag.getDefault();
        }
        return null;
    }

    public static FDPropertyDecl getPropertyDecl(EObject property) {
        EObject current = property;
        while (current != null && !(current instanceof FDPropertyDecl)) {
            current = current.eContainer();
        }
        return (FDPropertyDecl)current;
    }

    public static boolean isSpecification(EObject property) {
        EObject current = property;
        while (current != null) {
            if (current instanceof FDPropertyDecl) {
                return true;
            }
            if (current instanceof FDProperty) {
                return false;
            }
            current = current.eContainer();
        }
        return false;
    }

    public static boolean isDefault(EObject element) {
        FDPropertyDecl decl = GenericPropertyAccessor.getPropertyDecl(element);
        FDComplexValue value = GenericPropertyAccessor.getDefault(decl);
        if (value != null && value.getSingle() != null) {
            FDValue single = value.getSingle();
            if (FDModelUtils.isEnumerator(single)) {
                return FDModelUtils.getEnumerator(single) == element;
            }
            return single == element;
        }
        return false;
    }
}

