/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.franca.core.framework.FrancaHelpers;
import org.franca.core.franca.FArrayType;
import org.franca.core.franca.FAttribute;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FMapType;
import org.franca.core.franca.FStructType;
import org.franca.core.franca.FType;
import org.franca.core.franca.FTypeRef;
import org.franca.core.franca.FUnionType;
import org.franca.deploymodel.core.FDPropertyHost;
import org.franca.deploymodel.dsl.fDeploy.FDAbstractExtensionElement;
import org.franca.deploymodel.dsl.fDeploy.FDArgument;
import org.franca.deploymodel.dsl.fDeploy.FDArray;
import org.franca.deploymodel.dsl.fDeploy.FDAttribute;
import org.franca.deploymodel.dsl.fDeploy.FDBroadcast;
import org.franca.deploymodel.dsl.fDeploy.FDBuiltInPropertyHost;
import org.franca.deploymodel.dsl.fDeploy.FDDeclaration;
import org.franca.deploymodel.dsl.fDeploy.FDElement;
import org.franca.deploymodel.dsl.fDeploy.FDEnumValue;
import org.franca.deploymodel.dsl.fDeploy.FDEnumeration;
import org.franca.deploymodel.dsl.fDeploy.FDField;
import org.franca.deploymodel.dsl.fDeploy.FDInterface;
import org.franca.deploymodel.dsl.fDeploy.FDMap;
import org.franca.deploymodel.dsl.fDeploy.FDMapKey;
import org.franca.deploymodel.dsl.fDeploy.FDMapValue;
import org.franca.deploymodel.dsl.fDeploy.FDMethod;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyFlag;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;
import org.franca.deploymodel.dsl.fDeploy.FDStruct;
import org.franca.deploymodel.dsl.fDeploy.FDStructOverwrites;
import org.franca.deploymodel.dsl.fDeploy.FDTypedef;
import org.franca.deploymodel.dsl.fDeploy.FDTypes;
import org.franca.deploymodel.dsl.fDeploy.FDUnion;
import org.franca.deploymodel.dsl.fDeploy.FDUnionOverwrites;
import org.franca.deploymodel.extensions.ExtensionRegistry;
import org.franca.deploymodel.extensions.IFDeployExtension;

public class PropertyMappings {
    public static final List<FDPropertyDecl> getAllPropertyDecls(FDSpecification spec, FDElement elem) {
        HashSet hosts = Sets.newHashSet();
        FDBuiltInPropertyHost builtInMainHost = PropertyMappings.getBuiltInMainHost(elem);
        if (builtInMainHost != null) {
            FMapType mt;
            FAttribute te;
            HashSet builtinHosts = Sets.newHashSet((Object[])new FDBuiltInPropertyHost[]{builtInMainHost});
            FTypeRef typeRef = null;
            boolean isInlineArray = false;
            if (elem instanceof FDAttribute) {
                te = ((FDAttribute)elem).getTarget();
                typeRef = te.getType();
                if (te.isArray()) {
                    isInlineArray = true;
                }
            } else if (elem instanceof FDArgument) {
                te = ((FDArgument)elem).getTarget();
                typeRef = te.getType();
                if (te.isArray()) {
                    isInlineArray = true;
                }
            } else if (elem instanceof FDField) {
                te = ((FDField)elem).getTarget();
                typeRef = te.getType();
                if (te.isArray()) {
                    isInlineArray = true;
                }
            } else if (elem instanceof FDMapKey) {
                mt = ((FDMap)elem.eContainer()).getTarget();
                typeRef = mt.getKeyType();
            } else if (elem instanceof FDMapValue) {
                mt = ((FDMap)elem.eContainer()).getTarget();
                typeRef = mt.getValueType();
            }
            if (typeRef != null) {
                if (FrancaHelpers.isInteger((FTypeRef)typeRef)) {
                    builtinHosts.add(FDBuiltInPropertyHost.INTEGERS);
                } else if (FrancaHelpers.isFloatingPoint((FTypeRef)typeRef)) {
                    builtinHosts.add(FDBuiltInPropertyHost.FLOATS);
                } else if (FrancaHelpers.isString((FTypeRef)typeRef)) {
                    builtinHosts.add(FDBuiltInPropertyHost.STRINGS);
                } else if (FrancaHelpers.isBoolean((FTypeRef)typeRef)) {
                    builtinHosts.add(FDBuiltInPropertyHost.BOOLEANS);
                } else if (FrancaHelpers.isByteBuffer((FTypeRef)typeRef)) {
                    builtinHosts.add(FDBuiltInPropertyHost.BYTE_BUFFERS);
                }
            }
            if (isInlineArray) {
                builtinHosts.add(FDBuiltInPropertyHost.ARRAYS);
            }
            if (builtinHosts.contains((Object)FDBuiltInPropertyHost.INTEGERS) || builtinHosts.contains((Object)FDBuiltInPropertyHost.FLOATS)) {
                builtinHosts.add(FDBuiltInPropertyHost.NUMBERS);
            }
            if (builtinHosts.contains((Object)FDBuiltInPropertyHost.STRUCT_FIELDS) || builtinHosts.contains((Object)FDBuiltInPropertyHost.UNION_FIELDS)) {
                builtinHosts.add(FDBuiltInPropertyHost.FIELDS);
            }
            for (FDBuiltInPropertyHost h : builtinHosts) {
                hosts.add(new FDPropertyHost(h));
            }
        }
        if (elem instanceof FDAbstractExtensionElement) {
            IFDeployExtension.AbstractElementDef elementDef = ExtensionRegistry.getElement((FDAbstractExtensionElement)((Object)elem));
            for (IFDeployExtension.Host rh : elementDef.getHosts()) {
                hosts.add(new FDPropertyHost(rh.getName()));
            }
        } else {
            Iterable<IFDeployExtension.Host> additionalHosts = ExtensionRegistry.getAdditionalHosts(elem.eClass());
            for (IFDeployExtension.Host rh : additionalHosts) {
                hosts.add(new FDPropertyHost(rh.getName()));
            }
        }
        return PropertyMappings.getAllPropertyDeclsHelper(spec, hosts);
    }

    public static final List<FDPropertyDecl> getAllPropertyDecls(FDSpecification spec, FType type) {
        FDPropertyHost host = new FDPropertyHost(PropertyMappings.getMainHost(type));
        HashSet hosts = Sets.newHashSet((Object[])new FDPropertyHost[]{host});
        return PropertyMappings.getAllPropertyDeclsHelper(spec, hosts);
    }

    public static final List<FDPropertyDecl> getAllPropertyDecls(FDSpecification spec, FDPropertyHost host) {
        HashSet hosts = Sets.newHashSet((Object[])new FDPropertyHost[]{host});
        return PropertyMappings.getAllPropertyDeclsHelper(spec, hosts);
    }

    private static final List<FDPropertyDecl> getAllPropertyDeclsHelper(FDSpecification spec, Set<FDPropertyHost> hosts) {
        ArrayList properties = Lists.newArrayList();
        if (spec.getBase() != null && spec.getBase() != spec) {
            properties.addAll(PropertyMappings.getAllPropertyDeclsHelper(spec.getBase(), hosts));
        }
        for (FDDeclaration decl : spec.getDeclarations()) {
            if (!hosts.contains(decl.getHost())) continue;
            properties.addAll(decl.getProperties());
        }
        return properties;
    }

    private static FDBuiltInPropertyHost getBuiltInMainHost(FDElement elem) {
        if (elem instanceof FDInterface) {
            return FDBuiltInPropertyHost.INTERFACES;
        }
        if (elem instanceof FDTypes) {
            return FDBuiltInPropertyHost.TYPE_COLLECTIONS;
        }
        if (elem instanceof FDAttribute) {
            return FDBuiltInPropertyHost.ATTRIBUTES;
        }
        if (elem instanceof FDMethod) {
            return FDBuiltInPropertyHost.METHODS;
        }
        if (elem instanceof FDBroadcast) {
            return FDBuiltInPropertyHost.BROADCASTS;
        }
        if (elem instanceof FDArgument) {
            return FDBuiltInPropertyHost.ARGUMENTS;
        }
        if (elem instanceof FDArray) {
            return FDBuiltInPropertyHost.ARRAYS;
        }
        if (elem instanceof FDStruct || elem instanceof FDStructOverwrites) {
            return FDBuiltInPropertyHost.STRUCTS;
        }
        if (elem instanceof FDUnion || elem instanceof FDUnionOverwrites) {
            return FDBuiltInPropertyHost.UNIONS;
        }
        if (elem instanceof FDField) {
            EObject p = elem.eContainer();
            if (p instanceof FDStruct || p instanceof FDStructOverwrites) {
                return FDBuiltInPropertyHost.STRUCT_FIELDS;
            }
            if (p instanceof FDUnion || p instanceof FDUnionOverwrites) {
                return FDBuiltInPropertyHost.UNION_FIELDS;
            }
            return null;
        }
        if (elem instanceof FDEnumeration) {
            return FDBuiltInPropertyHost.ENUMERATIONS;
        }
        if (elem instanceof FDEnumValue) {
            return FDBuiltInPropertyHost.ENUMERATORS;
        }
        if (elem instanceof FDMap) {
            return FDBuiltInPropertyHost.MAPS;
        }
        if (elem instanceof FDMapKey) {
            return FDBuiltInPropertyHost.MAP_KEYS;
        }
        if (elem instanceof FDMapValue) {
            return FDBuiltInPropertyHost.MAP_VALUES;
        }
        if (elem instanceof FDTypedef) {
            return FDBuiltInPropertyHost.TYPEDEFS;
        }
        return null;
    }

    private static FDBuiltInPropertyHost getMainHost(FType type) {
        if (type instanceof FArrayType) {
            return FDBuiltInPropertyHost.ARRAYS;
        }
        if (type instanceof FStructType) {
            return FDBuiltInPropertyHost.STRUCTS;
        }
        if (type instanceof FUnionType) {
            return FDBuiltInPropertyHost.UNIONS;
        }
        if (type instanceof FEnumerationType) {
            return FDBuiltInPropertyHost.ENUMERATIONS;
        }
        if (type instanceof FMapType) {
            return FDBuiltInPropertyHost.MAPS;
        }
        return null;
    }

    public static boolean hasMandatoryProperties(List<FDPropertyDecl> decls) {
        for (FDPropertyDecl decl : decls) {
            if (!PropertyMappings.isMandatory(decl)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMandatory(FDPropertyDecl decl) {
        for (FDPropertyFlag flag : decl.getFlags()) {
            if (flag.getOptional() == null && flag.getDefault() == null) continue;
            return false;
        }
        return true;
    }
}

