/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.franca.deploymodel.dsl.fDeploy.FDArgument;
import org.franca.deploymodel.dsl.fDeploy.FDArgumentList;
import org.franca.deploymodel.dsl.fDeploy.FDArray;
import org.franca.deploymodel.dsl.fDeploy.FDElement;
import org.franca.deploymodel.dsl.fDeploy.FDEnumValue;
import org.franca.deploymodel.dsl.fDeploy.FDEnumeration;
import org.franca.deploymodel.dsl.fDeploy.FDField;
import org.franca.deploymodel.dsl.fDeploy.FDInterface;
import org.franca.deploymodel.dsl.fDeploy.FDMap;
import org.franca.deploymodel.dsl.fDeploy.FDRootElement;
import org.franca.deploymodel.dsl.fDeploy.FDStruct;
import org.franca.deploymodel.dsl.fDeploy.FDTypeDefinition;
import org.franca.deploymodel.dsl.fDeploy.FDTypedef;
import org.franca.deploymodel.dsl.fDeploy.FDTypes;
import org.franca.deploymodel.dsl.fDeploy.FDUnion;

public class FDMapper {
    Map<EObject, FDElement> mapping = Maps.newHashMap();

    public FDMapper(FDInterface fdi) {
        this.init(fdi);
    }

    public FDMapper(FDTypes fdt) {
        this.initTypeCollection(fdt);
    }

    public FDElement getFDElement(EObject obj) {
        return this.mapping.get(obj);
    }

    private void init(FDInterface fdi) {
        this.mapping.put((EObject)fdi.getTarget(), fdi);
        for (FDElement e : fdi.getAttributes()) {
            this.mapping.put((EObject)e.getTarget(), e);
        }
        for (FDElement e : fdi.getMethods()) {
            this.mapping.put((EObject)e.getTarget(), e);
            this.initArguments(e.getInArguments());
            this.initArguments(e.getOutArguments());
        }
        for (FDElement e : fdi.getBroadcasts()) {
            this.mapping.put((EObject)e.getTarget(), e);
            this.initArguments(e.getOutArguments());
        }
        this.initTypes((List<FDTypeDefinition>)fdi.getTypes());
        this.initReferenced((Collection<FDRootElement>)fdi.getUse());
    }

    private void initReferenced(Collection<FDRootElement> used) {
        LinkedList work = Lists.newLinkedList();
        HashSet visited = Sets.newHashSet();
        work.addAll(used);
        while (!work.isEmpty()) {
            FDTypes fdTypes;
            FDRootElement e = (FDRootElement)work.poll();
            if (!(e instanceof FDTypes) || visited.contains(fdTypes = (FDTypes)e)) continue;
            visited.add(fdTypes);
            this.initTypeCollection(fdTypes);
            work.addAll(e.getUse());
        }
    }

    private void initTypeCollection(FDTypes fdTypes) {
        this.mapping.put((EObject)fdTypes.getTarget(), fdTypes);
        this.initTypes((List<FDTypeDefinition>)fdTypes.getTypes());
    }

    private void initTypes(List<FDTypeDefinition> fdTypes) {
        for (FDTypeDefinition t : fdTypes) {
            if (t instanceof FDArray) {
                this.mapping.put((EObject)((FDArray)t).getTarget(), t);
                continue;
            }
            if (t instanceof FDStruct) {
                this.mapping.put((EObject)((FDStruct)t).getTarget(), t);
                for (FDField f : ((FDStruct)t).getFields()) {
                    this.mapping.put((EObject)f.getTarget(), f);
                }
                continue;
            }
            if (t instanceof FDUnion) {
                this.mapping.put((EObject)((FDUnion)t).getTarget(), t);
                for (FDField f : ((FDUnion)t).getFields()) {
                    this.mapping.put((EObject)f.getTarget(), f);
                }
                continue;
            }
            if (t instanceof FDEnumeration) {
                this.mapping.put((EObject)((FDEnumeration)t).getTarget(), t);
                for (FDEnumValue e : ((FDEnumeration)t).getEnumerators()) {
                    this.mapping.put((EObject)e.getTarget(), e);
                }
                continue;
            }
            if (t instanceof FDMap) {
                this.mapping.put((EObject)((FDMap)t).getTarget(), t);
                continue;
            }
            if (!(t instanceof FDTypedef)) continue;
            this.mapping.put((EObject)((FDTypedef)t).getTarget(), t);
        }
    }

    private void initArguments(FDArgumentList args) {
        if (args == null) {
            return;
        }
        for (FDArgument arg : args.getArguments()) {
            this.mapping.put((EObject)arg.getTarget(), arg);
        }
    }
}

