/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.franca.deploymodel.core.FDPropertyHost;
import org.franca.deploymodel.core.PropertyMappings;
import org.franca.deploymodel.dsl.fDeploy.FDBuiltInPropertyHost;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;

public class FDSpecificationExtender {
    private FDSpecification spec = null;
    private Map<FDPropertyHost, List<FDPropertyDecl>> declarations = Maps.newHashMap();
    private Map<FDPropertyHost, Boolean> hasMandatoryProps = Maps.newHashMap();

    public FDSpecificationExtender(FDSpecification spec) {
        this.spec = spec;
    }

    public boolean isMandatory(FDBuiltInPropertyHost host) {
        return this.isMandatory(FDPropertyHost.builtIn(host));
    }

    public boolean isMandatory(FDPropertyHost host) {
        if (!this.hasMandatoryProps.containsKey(host)) {
            this.createEntry(host);
        }
        return this.hasMandatoryProps.get(host);
    }

    public List<FDPropertyDecl> getDecls(FDPropertyHost host) {
        if (!this.declarations.containsKey(host)) {
            this.createEntry(host);
        }
        return this.declarations.get(host);
    }

    private void createEntry(FDPropertyHost host) {
        List<FDPropertyDecl> decls = PropertyMappings.getAllPropertyDecls(this.spec, host);
        this.declarations.put(host, decls);
        this.hasMandatoryProps.put(host, PropertyMappings.hasMandatoryProperties(decls));
    }
}

