/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.franca.core.dsl.FrancaIDLStandaloneSetup;
import org.franca.core.dsl.FrancaImportsProvider;
import org.franca.core.utils.FileHelper;
import org.franca.core.utils.ImportsProvider;
import org.franca.core.utils.ModelPersistenceHandler;
import org.franca.deploymodel.dsl.FDeployImportsProvider;
import org.franca.deploymodel.dsl.fDeploy.FDModel;

public class FDeployPersistenceManager {
    private final String fileExtension = "fdepl";
    @Inject
    private Provider<ResourceSet> resourceSetProvider;

    public FDeployPersistenceManager() {
        new FrancaIDLStandaloneSetup().createInjectorAndDoEMFRegistration();
    }

    public FDModel loadModel(String filename) {
        URI uri = FileHelper.createURI((String)filename);
        if (uri.segmentCount() > 1) {
            return this.loadModel(uri.lastSegment(), String.valueOf(uri.trimSegments(1).toString()) + "/");
        }
        return this.loadModel(filename, "");
    }

    public FDModel loadModel(URI uri, URI root) {
        ModelPersistenceHandler persistenceHandler = this.createModelPersistenceHandler((ResourceSet)this.resourceSetProvider.get());
        return (FDModel)persistenceHandler.loadModel(uri, root);
    }

    public FDModel loadModel(String filename, String cwd) {
        String fn = filename;
        if (fn == null) {
            return null;
        }
        if (!fn.endsWith(".fdepl")) {
            fn = String.valueOf(fn) + ".fdepl";
        }
        ModelPersistenceHandler persistenceHandler = this.createModelPersistenceHandler((ResourceSet)this.resourceSetProvider.get());
        return (FDModel)persistenceHandler.loadModel(fn, cwd);
    }

    public boolean saveModel(FDModel model, String filename) {
        URI uri = FileHelper.createURI((String)filename);
        if (uri.segmentCount() > 1) {
            return this.saveModel(model, uri.lastSegment(), String.valueOf(uri.trimSegments(1).toString()) + "/");
        }
        return this.saveModel(model, filename, "");
    }

    public boolean saveModel(FDModel model, String filename, String cwd) {
        ResourceSet resourceSet = null;
        String fn = filename;
        if (fn == null) {
            return false;
        }
        if (!fn.endsWith(".fdepl")) {
            fn = String.valueOf(fn) + ".fdepl";
        }
        resourceSet = model.eResource() == null ? (ResourceSet)this.resourceSetProvider.get() : model.eResource().getResourceSet();
        ModelPersistenceHandler persistenceHandler = this.createModelPersistenceHandler(resourceSet);
        return persistenceHandler.saveModel((EObject)model, fn, cwd);
    }

    private ModelPersistenceHandler createModelPersistenceHandler(ResourceSet resourceSet) {
        ModelPersistenceHandler.registerFileExtensionHandler((String)"fdepl", (ImportsProvider)new FDeployImportsProvider());
        ModelPersistenceHandler.registerFileExtensionHandler((String)"fidl", (ImportsProvider)new FrancaImportsProvider());
        ModelPersistenceHandler persistenceHandler = new ModelPersistenceHandler(resourceSet);
        return persistenceHandler;
    }
}

