/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.generator.internal;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.core.franca.FArgument;
import org.franca.core.franca.FArrayType;
import org.franca.core.franca.FAttribute;
import org.franca.core.franca.FField;
import org.franca.deploymodel.core.FDPropertyHost;
import org.franca.deploymodel.dsl.fDeploy.FDAbstractExtensionElement;
import org.franca.deploymodel.dsl.fDeploy.FDBuiltInPropertyHost;
import org.franca.deploymodel.dsl.fDeploy.FDDeclaration;
import org.franca.deploymodel.dsl.fDeploy.FDEnumType;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;
import org.franca.deploymodel.dsl.fDeploy.FDType;
import org.franca.deploymodel.dsl.generator.internal.GeneratorHelper;
import org.franca.deploymodel.dsl.generator.internal.HostLogic;
import org.franca.deploymodel.dsl.generator.internal.ICodeContext;
import org.franca.deploymodel.dsl.generator.internal.ImportManager;

public abstract class AccessMethodGenerator {
    @Inject
    @Extension
    private ImportManager _importManager;

    public CharSequence generateAccessMethods(FDSpecification spec, boolean forInterfaces, ICodeContext context) {
        StringConcatenation _builder = new StringConcatenation();
        EList<FDDeclaration> _declarations = spec.getDeclarations();
        for (FDDeclaration d : _declarations) {
            String _genProperties = this.genProperties(d, forInterfaces, context);
            _builder.append(_genProperties);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected abstract CharSequence genMethod(FDPropertyDecl var1, Class<? extends EObject> var2, boolean var3);

    protected abstract CharSequence genEnumMethod(FDPropertyDecl var1, Class<? extends EObject> var2, String var3, String var4, FDEnumType var5, boolean var6);

    private String genProperties(FDDeclaration decl, boolean forInterfaces, ICodeContext context) {
        boolean isExtensionClass;
        String _xblockexpression = null;
        HostLogic.Context hostContext = this.getHostContext(forInterfaces);
        Class<? extends EObject> argtype = HostLogic.getArgumentType(decl.getHost(), hostContext);
        if (decl.getProperties().size() > 0 && argtype != null && !(isExtensionClass = FDAbstractExtensionElement.class.isAssignableFrom(argtype))) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("// host '");
            String _name = decl.getHost().getName();
            _builder.append(_name);
            _builder.append("'");
            _builder.newLineIfNotEmpty();
            EList<FDPropertyDecl> _properties = decl.getProperties();
            for (FDPropertyDecl p : _properties) {
                CharSequence _genProperty = this.genProperty(p, decl.getHost(), forInterfaces, context);
                _builder.append((Object)_genProperty);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
            return _builder.toString();
        }
        _xblockexpression = "";
        return _xblockexpression;
    }

    private CharSequence genProperty(FDPropertyDecl pd, FDPropertyHost host, boolean forInterfaces, ICodeContext context) {
        CharSequence _xifexpression = null;
        boolean _isBuiltIn = host.isBuiltIn(FDBuiltInPropertyHost.ARRAYS);
        if (_isBuiltIn) {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _genProperty = this.genProperty(pd, host, FArrayType.class, false, context);
            _builder.append((Object)_genProperty);
            _builder.newLineIfNotEmpty();
            CharSequence _genProperty_1 = this.genProperty(pd, host, FField.class, false, context);
            _builder.append((Object)_genProperty_1);
            _builder.newLineIfNotEmpty();
            if (forInterfaces) {
                CharSequence _genProperty_2 = this.genProperty(pd, host, FAttribute.class, true, context);
                _builder.append((Object)_genProperty_2);
                _builder.newLineIfNotEmpty();
                CharSequence _genProperty_3 = this.genProperty(pd, host, FArgument.class, true, context);
                _builder.append((Object)_genProperty_3);
                _builder.newLineIfNotEmpty();
            }
            _xifexpression = _builder;
        } else {
            CharSequence _xblockexpression = null;
            HostLogic.Context hostContext = this.getHostContext(forInterfaces);
            Class<? extends EObject> argtype = HostLogic.getArgumentType(host, hostContext);
            _xifexpression = _xblockexpression = this.genProperty(pd, host, argtype, false, context);
        }
        return _xifexpression;
    }

    private HostLogic.Context getHostContext(boolean forInterfaces) {
        HostLogic.Context _xifexpression = null;
        _xifexpression = forInterfaces ? HostLogic.Context.FRANCA_INTERFACE : HostLogic.Context.FRANCA_TYPE;
        return _xifexpression;
    }

    private CharSequence genProperty(FDPropertyDecl it, FDPropertyHost host, Class<? extends EObject> argumentType, boolean forceInterfaceOnly, ICodeContext context) {
        String _xblockexpression = null;
        this._importManager.addNeededFrancaType(argumentType);
        boolean isOnlyForInterface = forceInterfaceOnly || HostLogic.isInterfaceOnly(host);
        CharSequence _xifexpression = null;
        if (argumentType != null) {
            CharSequence _xblockexpression_1 = null;
            context.requireTargetMember();
            CharSequence _xifexpression_1 = null;
            boolean _isEnum = GeneratorHelper.isEnum(it);
            if (_isEnum) {
                CharSequence _xblockexpression_2 = null;
                String enumType = StringExtensions.toFirstUpper((String)it.getName());
                String _xifexpression_2 = null;
                String _array = it.getType().getArray();
                boolean _tripleEquals = _array == null;
                _xifexpression_2 = _tripleEquals ? enumType : this._importManager.genListType(enumType).toString();
                String retType = _xifexpression_2;
                FDType _complex = it.getType().getComplex();
                FDEnumType enumerator = (FDEnumType)_complex;
                _xifexpression_1 = _xblockexpression_2 = this.genEnumMethod(it, argumentType, enumType, retType, enumerator, !isOnlyForInterface);
            } else {
                _xifexpression_1 = this.genMethod(it, argumentType, !isOnlyForInterface);
            }
            _xblockexpression_1 = _xifexpression_1;
            _xifexpression = _xblockexpression_1;
        } else {
            _xifexpression = "";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected CharSequence genHelpForGetOverwriteAccessor(Class<? extends EObject> argumentType, String objname) {
        StringConcatenation _xblockexpression = null;
        String typename = argumentType.getSimpleName();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Get an overwrite-aware accessor for deployment properties.</p>");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This accessor will return overwritten property values in the context ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* of a Franca ");
        _builder.append(typename, " ");
        _builder.append(" object. I.e., the ");
        _builder.append(typename, " ");
        _builder.append(" ");
        _builder.append(objname, " ");
        _builder.append(" has a datatype");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* which can be overwritten in the deployment definition (e.g., Franca array,");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* struct, union or enumeration). The accessor will return the overwritten values.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* If the deployment definition didn't overwrite the value, this accessor will");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* delegate to its parent accessor.</p>");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param ");
        _builder.append(objname, " ");
        _builder.append(" a Franca ");
        _builder.append(typename, " ");
        _builder.append(" which is the context for the accessor");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @return the overwrite-aware accessor");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

