/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.generator.internal;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.core.franca.FModelElement;
import org.franca.deploymodel.core.FDPropertyHost;
import org.franca.deploymodel.dsl.fDeploy.FDDeclaration;
import org.franca.deploymodel.dsl.fDeploy.FDEnumType;
import org.franca.deploymodel.dsl.fDeploy.FDEnumerator;
import org.franca.deploymodel.dsl.fDeploy.FDOverwriteElement;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;
import org.franca.deploymodel.dsl.fDeploy.FDType;
import org.franca.deploymodel.dsl.generator.internal.ImportManager;

public class HelperGenerator {
    @Inject
    @Extension
    private ImportManager _importManager;

    public CharSequence generate(FDSpecification spec) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Helper class for data-related property accessors.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/\t\t");
        _builder.newLine();
        _builder.append("public static class DataPropertyAccessorHelper implements Enums");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("final private MappingGenericPropertyAccessor target;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("final private IDataPropertyAccessor owner;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public DataPropertyAccessorHelper(");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("MappingGenericPropertyAccessor target,");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("IDataPropertyAccessor owner");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(") {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.target = target;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.owner = owner;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        EList<FDDeclaration> _declarations = spec.getDeclarations();
        for (FDDeclaration d : _declarations) {
            _builder.append("\t");
            CharSequence _genProperties = this.genProperties(d);
            _builder.append((Object)_genProperties, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        this._importManager.addNeededFrancaType(FModelElement.class);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected IDataPropertyAccessor getOverwriteAccessorAux(FModelElement obj) {");
        _builder.newLine();
        _builder.append("\t\t");
        this._importManager.addNeededFrancaType(FDOverwriteElement.class);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("FDOverwriteElement fd = (FDOverwriteElement)target.getFDElement(obj);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("FDTypeOverwrites overwrites = fd.getOverwrites();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (overwrites==null)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return owner;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return new OverwriteAccessor(overwrites, owner, target);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence genProperties(FDDeclaration decl) {
        StringConcatenation _builder = new StringConcatenation();
        EList<FDPropertyDecl> _properties = decl.getProperties();
        for (FDPropertyDecl p : _properties) {
            CharSequence _genProperty = this.genProperty(p, decl.getHost());
            _builder.append((Object)_genProperty);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence genProperty(FDPropertyDecl it, FDPropertyHost host) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _genEnumConverter = this.genEnumConverter(it);
        _builder.append((Object)_genEnumConverter);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence genEnumConverter(FDPropertyDecl it) {
        String _xifexpression = null;
        if (it.getType().getComplex() != null && it.getType().getComplex() instanceof FDEnumType) {
            StringConcatenation _xblockexpression = null;
            String etname = StringExtensions.toFirstUpper((String)it.getName());
            FDType _complex = it.getType().getComplex();
            FDEnumType enumerator = (FDEnumType)_complex;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("public static ");
            _builder.append(etname);
            _builder.append(" convert");
            _builder.append(etname);
            _builder.append("(String val) {");
            _builder.newLineIfNotEmpty();
            EList<FDEnumerator> _enumerators = enumerator.getEnumerators();
            boolean _hasElements = false;
            for (FDEnumerator e : _enumerators) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)" else ", "\t");
                }
                _builder.append("\t");
                _builder.append("if (val.equals(\"");
                String _name = e.getName();
                _builder.append(_name, "\t");
                _builder.append("\"))");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return ");
                _builder.append(etname, "\t\t");
                _builder.append(".");
                String _name_1 = e.getName();
                _builder.append(_name_1, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("return null;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _xblockexpression = _builder;
            _xifexpression = _xblockexpression;
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }
}

