/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.generator.internal;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.franca.core.franca.FArgument;
import org.franca.core.franca.FAttribute;
import org.franca.core.franca.FBroadcast;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FEnumerator;
import org.franca.core.franca.FField;
import org.franca.core.franca.FInterface;
import org.franca.core.franca.FMapType;
import org.franca.core.franca.FMethod;
import org.franca.core.franca.FStructType;
import org.franca.core.franca.FTypeCollection;
import org.franca.core.franca.FTypeDef;
import org.franca.core.franca.FUnionType;
import org.franca.deploymodel.core.FDPropertyHost;
import org.franca.deploymodel.dsl.fDeploy.FDBuiltInPropertyHost;
import org.franca.deploymodel.dsl.fDeploy.FDeployPackage;
import org.franca.deploymodel.dsl.generator.internal.SuperclassFinder;
import org.franca.deploymodel.extensions.ExtensionRegistry;
import org.franca.deploymodel.extensions.IFDeployExtension;

public class HostLogic {
    private static final Set<Class<? extends EObject>> interfaceSpecificClasses = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Class[]{FInterface.class, FAttribute.class, FMethod.class, FBroadcast.class, FArgument.class}));

    public static Class<? extends EObject> getArgumentType(FDPropertyHost host, Context context) {
        Class<? extends EObject> _xblockexpression = null;
        FDBuiltInPropertyHost builtIn = host.getBuiltIn();
        Class<? extends EObject> _xifexpression = null;
        if (builtIn != null) {
            Class<EObject> _switchResult = null;
            if (builtIn != null) {
                switch (builtIn) {
                    case TYPE_COLLECTIONS: {
                        _switchResult = FTypeCollection.class;
                        break;
                    }
                    case INTERFACES: {
                        _switchResult = FInterface.class;
                        break;
                    }
                    case ATTRIBUTES: {
                        _switchResult = FAttribute.class;
                        break;
                    }
                    case METHODS: {
                        _switchResult = FMethod.class;
                        break;
                    }
                    case BROADCASTS: {
                        _switchResult = FBroadcast.class;
                        break;
                    }
                    case ARGUMENTS: {
                        _switchResult = FArgument.class;
                        break;
                    }
                    case STRUCTS: {
                        _switchResult = FStructType.class;
                        break;
                    }
                    case UNIONS: {
                        _switchResult = FUnionType.class;
                        break;
                    }
                    case STRUCT_FIELDS: {
                        _switchResult = FField.class;
                        break;
                    }
                    case UNION_FIELDS: {
                        _switchResult = FField.class;
                        break;
                    }
                    case FIELDS: {
                        _switchResult = FField.class;
                        break;
                    }
                    case ENUMERATIONS: {
                        _switchResult = FEnumerationType.class;
                        break;
                    }
                    case ENUMERATORS: {
                        _switchResult = FEnumerator.class;
                        break;
                    }
                    case MAPS: {
                        _switchResult = FMapType.class;
                        break;
                    }
                    case MAP_KEYS: {
                        _switchResult = FMapType.class;
                        break;
                    }
                    case MAP_VALUES: {
                        _switchResult = FMapType.class;
                        break;
                    }
                    case TYPEDEFS: {
                        _switchResult = FTypeDef.class;
                        break;
                    }
                    default: {
                        _switchResult = EObject.class;
                        break;
                    }
                }
            } else {
                _switchResult = EObject.class;
            }
            _xifexpression = _switchResult;
        } else {
            _xifexpression = HostLogic.getArgumentTypeForExtensionHost(host, context);
        }
        Class<? extends EObject> result = _xifexpression;
        Class<? extends EObject> _xifexpression_1 = null;
        if (result == null) {
            _xifexpression_1 = null;
        } else {
            Class<Object> _xifexpression_2 = null;
            _xifexpression_2 = context != Context.FRANCA_INTERFACE && interfaceSpecificClasses.contains(result) ? null : result;
            _xifexpression_1 = _xifexpression_2;
        }
        _xblockexpression = _xifexpression_1;
        return _xblockexpression;
    }

    private static Class<? extends EObject> getArgumentTypeForExtensionHost(FDPropertyHost host, Context context) {
        Class<EObject> _xblockexpression = null;
        IFDeployExtension.Host hostDef = ExtensionRegistry.findHost(host.getName());
        if (hostDef != null) {
            Class instClass;
            boolean _isAssignableFrom;
            SuperclassFinder sd;
            EClassifier superclass;
            boolean _not;
            Set<EClass> classes = ExtensionRegistry.getHostingClasses(hostDef);
            Iterable _xifexpression = null;
            if (context == Context.NON_FRANCA) {
                Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

                    public Boolean apply(EClass it) {
                        return ExtensionRegistry.isNonFrancaMixinHost(it) || FDeployPackage.eINSTANCE.getFDAbstractExtensionElement().isSuperTypeOf(it);
                    }
                };
                _xifexpression = IterableExtensions.filter(classes, (Functions.Function1)_function);
            } else {
                Functions.Function1<EClass, Boolean> _function_1 = new Functions.Function1<EClass, Boolean>(){

                    public Boolean apply(EClass it) {
                        boolean _isNonFrancaMixinHost = ExtensionRegistry.isNonFrancaMixinHost(it);
                        return !_isNonFrancaMixinHost;
                    }
                };
                _xifexpression = IterableExtensions.filter(classes, (Functions.Function1)_function_1);
            }
            Iterable filtered = _xifexpression;
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)filtered);
            if (_isEmpty) {
                return null;
            }
            Functions.Function1<EClass, EClassifier> _function_2 = new Functions.Function1<EClass, EClassifier>(){

                public EClassifier apply(EClass it) {
                    return ExtensionRegistry.getAccessorArgumentType(it);
                }
            };
            Iterable targetClasses = IterableExtensions.map((Iterable)filtered, (Functions.Function1)_function_2);
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)targetClasses);
            boolean bl = _not = !_isEmpty_1;
            if (_not && (superclass = (sd = new SuperclassFinder()).findCommonSuperclass(targetClasses)) != null && (_isAssignableFrom = EObject.class.isAssignableFrom(instClass = superclass.getInstanceClass()))) {
                return instClass;
            }
        }
        _xblockexpression = EObject.class;
        return _xblockexpression;
    }

    public static boolean isInterfaceOnly(FDPropertyHost host) {
        return HostLogic.getArgumentType(host, Context.FRANCA_TYPE) == null && HostLogic.getArgumentType(host, Context.FRANCA_INTERFACE) != null;
    }

    public static boolean isHostFor(FDPropertyHost host, IFDeployExtension.AbstractElementDef elementDef) {
        boolean _tripleNotEquals;
        boolean _xifexpression = false;
        FDBuiltInPropertyHost _builtIn = host.getBuiltIn();
        boolean bl = _tripleNotEquals = _builtIn != null;
        if (_tripleNotEquals) {
            _xifexpression = false;
        } else {
            boolean _xblockexpression = false;
            IFDeployExtension.Host hostDef = ExtensionRegistry.findHost(host.getName());
            _xifexpression = _xblockexpression = ExtensionRegistry.hasHostSubtree(elementDef, hostDef);
        }
        return _xifexpression;
    }

    public static boolean isHostFor(FDPropertyHost host, EClass mixinRoot) {
        boolean _tripleNotEquals;
        boolean _xifexpression = false;
        FDBuiltInPropertyHost _builtIn = host.getBuiltIn();
        boolean bl = _tripleNotEquals = _builtIn != null;
        if (_tripleNotEquals) {
            _xifexpression = false;
        } else {
            boolean _xblockexpression = false;
            IFDeployExtension.Host hostDef = ExtensionRegistry.findHost(host.getName());
            Iterable<EClass> classes = ExtensionRegistry.getMixinClasses(mixinRoot);
            Functions.Function1<EClass, Iterable<IFDeployExtension.Host>> _function = new Functions.Function1<EClass, Iterable<IFDeployExtension.Host>>(){

                public Iterable<IFDeployExtension.Host> apply(EClass it) {
                    return ExtensionRegistry.getAdditionalHosts(it);
                }
            };
            Set supportedHosts = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map(classes, (Functions.Function1)_function)));
            _xifexpression = _xblockexpression = supportedHosts.contains(hostDef);
        }
        return _xifexpression;
    }

    public static enum Context {
        FRANCA_TYPE,
        FRANCA_INTERFACE,
        NON_FRANCA;

    }
}

