/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.generator.internal;

import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.franca.core.franca.FInterface;
import org.franca.deploymodel.dsl.fDeploy.FDEnumType;
import org.franca.deploymodel.dsl.fDeploy.FDExtensionType;
import org.franca.deploymodel.dsl.fDeploy.FDPredefinedTypeId;
import org.franca.deploymodel.dsl.fDeploy.FDType;
import org.franca.deploymodel.dsl.fDeploy.FDTypeRef;
import org.franca.deploymodel.extensions.ExtensionRegistry;
import org.franca.deploymodel.extensions.IFDeployExtension;

@Singleton
public class ImportManager {
    private Set<Class<? extends EObject>> neededFrancaTypes;
    private Set<Class<?>> neededOtherTypes;
    private boolean needList;
    private boolean needArrayList;

    public boolean initImportManager() {
        boolean _xblockexpression = false;
        this.neededFrancaTypes = CollectionLiterals.newHashSet((Object[])new Class[0]);
        this.neededOtherTypes = CollectionLiterals.newHashSet((Object[])new Class[0]);
        this.needList = false;
        this.needArrayList = false;
        _xblockexpression = false;
        return _xblockexpression;
    }

    public CharSequence getJavaType(FDTypeRef typeRef) {
        boolean _tripleEquals_1;
        CharSequence _xblockexpression_3;
        boolean _tripleEquals;
        String _xblockexpression = null;
        String _xifexpression = null;
        FDType _complex = typeRef.getComplex();
        boolean bl = _tripleEquals = _complex == null;
        if (_tripleEquals) {
            String _switchResult = null;
            FDPredefinedTypeId _predefined = typeRef.getPredefined();
            if (_predefined != null) {
                switch (_predefined) {
                    case BOOLEAN: {
                        _switchResult = "Boolean";
                        break;
                    }
                    case INTEGER: {
                        _switchResult = "Integer";
                        break;
                    }
                    case STRING: {
                        _switchResult = "String";
                        break;
                    }
                    case INTERFACE: {
                        String _xblockexpression_1 = null;
                        this.neededFrancaTypes.add(FInterface.class);
                        _switchResult = _xblockexpression_1 = "FInterface";
                        break;
                    }
                }
            }
            _xifexpression = _switchResult;
        } else {
            String _xblockexpression_2 = null;
            FDType ct = typeRef.getComplex();
            CharSequence _switchResult_1 = null;
            boolean _matched = false;
            if (ct instanceof FDEnumType) {
                _matched = true;
                _switchResult_1 = "String";
            }
            if (!_matched && ct instanceof FDExtensionType) {
                _matched = true;
                _xblockexpression_3 = null;
                IFDeployExtension.TypeDef typeDef = ExtensionRegistry.findType(((FDExtensionType)ct).getName());
                Class<? extends EObject> t = typeDef.getRuntimeType();
                this.neededFrancaTypes.add(t);
                _xblockexpression_3 = t.getSimpleName();
                _switchResult_1 = _xblockexpression_3;
            }
            _xifexpression = _xblockexpression_2 = _switchResult_1;
        }
        String single = _xifexpression;
        CharSequence _xifexpression_1 = null;
        String _array = typeRef.getArray();
        boolean bl2 = _tripleEquals_1 = _array == null;
        if (_tripleEquals_1) {
            _xifexpression_1 = single;
        } else {
            _xblockexpression_3 = null;
            this.needList = true;
            _xblockexpression_3 = this.genListType(single);
            _xifexpression_1 = _xblockexpression_3;
        }
        _xblockexpression = _xifexpression_1;
        return _xblockexpression;
    }

    public void addNeededFrancaType(Class<? extends EObject> clazz) {
        this.neededFrancaTypes.add(clazz);
    }

    public void addNeededOtherType(Class<?> clazz) {
        this.neededOtherTypes.add(clazz);
    }

    public CharSequence genListType(String type) {
        StringConcatenation _xblockexpression = null;
        this.setNeedArrayList();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("List<");
        _builder.append(type);
        _builder.append(">");
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public boolean setNeedArrayList() {
        this.needArrayList = true;
        return true;
    }

    public boolean needList() {
        return this.needList;
    }

    public Iterable<String> getNeededFrancaTypes() {
        Functions.Function1<Class<? extends EObject>, String> _function = new Functions.Function1<Class<? extends EObject>, String>(){

            public String apply(Class<? extends EObject> it) {
                return it.getSimpleName();
            }
        };
        return IterableExtensions.map(this.neededFrancaTypes, (Functions.Function1)_function);
    }

    public CharSequence genImports() {
        StringConcatenation _builder = new StringConcatenation();
        if (this.needList) {
            _builder.append("import java.util.List;");
            _builder.newLine();
            _builder.append("import java.util.ArrayList;");
            _builder.newLine();
        }
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = new Functions.Function1<Class<?>, String>(){

            public String apply(Class<?> it) {
                return it.getCanonicalName();
            }
        };
        List _sort = IterableExtensions.sort((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)Sets.union(this.neededFrancaTypes, this.neededOtherTypes), (Functions.Function1)_function)));
        for (String p : _sort) {
            _builder.append("import ");
            _builder.append(p);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("import com.google.common.collect.Maps;");
        _builder.newLine();
        return _builder;
    }
}

