/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.generator.internal;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FEnumerator;
import org.franca.core.franca.FField;
import org.franca.deploymodel.core.MappingGenericPropertyAccessor;
import org.franca.deploymodel.dsl.fDeploy.FDCompoundOverwrites;
import org.franca.deploymodel.dsl.fDeploy.FDEnumType;
import org.franca.deploymodel.dsl.fDeploy.FDEnumValue;
import org.franca.deploymodel.dsl.fDeploy.FDEnumerationOverwrites;
import org.franca.deploymodel.dsl.fDeploy.FDField;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;
import org.franca.deploymodel.dsl.fDeploy.FDTypeOverwrites;
import org.franca.deploymodel.dsl.generator.internal.AccessMethodGenerator;
import org.franca.deploymodel.dsl.generator.internal.CodeContext;
import org.franca.deploymodel.dsl.generator.internal.GeneratorHelper;
import org.franca.deploymodel.dsl.generator.internal.ImportManager;

public class OverwriteAccessorGenerator
extends AccessMethodGenerator {
    @Inject
    @Extension
    private ImportManager _importManager;

    public CharSequence generate(FDSpecification spec) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Accessor for getting overwritten property values.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/\t\t");
        _builder.newLine();
        _builder.append("public static class OverwriteAccessor");
        _builder.newLine();
        _builder.append("\t");
        FDSpecification _base = spec.getBase();
        boolean bl = _tripleNotEquals = _base != null;
        if (_tripleNotEquals) {
            _builder.append("extends ");
            String _qualifiedClassname = GeneratorHelper.getQualifiedClassname(spec.getBase());
            _builder.append(_qualifiedClassname, "\t");
            _builder.append(".OverwriteAccessor");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("implements IDataPropertyAccessor");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        this._importManager.addNeededOtherType(MappingGenericPropertyAccessor.class);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private final MappingGenericPropertyAccessor target;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private final IDataPropertyAccessor delegate;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private final FDTypeOverwrites overwrites;");
        _builder.newLine();
        _builder.append("\t");
        this._importManager.addNeededFrancaType(FField.class);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private final Map<FField, FDField> mappedFields;");
        _builder.newLine();
        _builder.append("\t");
        this._importManager.addNeededFrancaType(FEnumerator.class);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private final Map<FEnumerator, FDEnumValue> mappedEnumerators;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        this._importManager.addNeededFrancaType(FDTypeOverwrites.class);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public OverwriteAccessor(");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("FDTypeOverwrites overwrites,");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("IDataPropertyAccessor delegate,");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("MappingGenericPropertyAccessor genericAccessor)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        FDSpecification _base_1 = spec.getBase();
        boolean bl2 = _tripleNotEquals_1 = _base_1 != null;
        if (_tripleNotEquals_1) {
            _builder.append("\t\t");
            _builder.append("super(overwrites, delegate, genericAccessor);");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("this.target = genericAccessor;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.delegate = delegate;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.overwrites = overwrites;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.mappedFields = Maps.newHashMap();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.mappedEnumerators = Maps.newHashMap();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (overwrites!=null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (overwrites instanceof FDCompoundOverwrites) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// build mapping for compound fields");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        this._importManager.addNeededFrancaType(FDField.class);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        this._importManager.addNeededFrancaType(FDCompoundOverwrites.class);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("for(FDField f : ((FDCompoundOverwrites)overwrites).getFields()) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("this.mappedFields.put(f.getTarget(), f);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (overwrites instanceof FDEnumerationOverwrites) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// build mapping for enumerators");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        this._importManager.addNeededFrancaType(FDEnumValue.class);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        this._importManager.addNeededFrancaType(FDEnumerationOverwrites.class);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("for(FDEnumValue e : ((FDEnumerationOverwrites)overwrites).getEnumerators()) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("this.mappedEnumerators.put(e.getTarget(), e);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CodeContext _codeContext = new CodeContext();
        CharSequence _generateAccessMethods = this.generateAccessMethods(spec, false, _codeContext);
        _builder.append((Object)_generateAccessMethods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public IDataPropertyAccessor getOverwriteAccessor(FField obj) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// check if this field is overwritten");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (mappedFields.containsKey(obj)) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("FDField fo = mappedFields.get(obj);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("FDTypeOverwrites overwrites = fo.getOverwrites();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (overwrites==null)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return this; // TODO: correct?");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// TODO: this or delegate?");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return new OverwriteAccessor(overwrites, this, target);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return delegate.getOverwriteAccessor(obj);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public IDataPropertyAccessor getOverwriteAccessor(FArrayType obj) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// check if this array is overwritten");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (overwrites!=null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// TODO: this or delegate?");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return new OverwriteAccessor(overwrites, this, target);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return delegate.getOverwriteAccessor(obj);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    @Override
    public CharSequence genMethod(FDPropertyDecl it, Class<? extends EObject> argumentType, boolean isData) {
        StringConcatenation _builder = new StringConcatenation();
        if (isData) {
            _builder.append("@Override");
            _builder.newLine();
        }
        _builder.append("public ");
        CharSequence _javaType = this._importManager.getJavaType(it.getType());
        _builder.append((Object)_javaType);
        _builder.append(" ");
        CharSequence _methodName = GeneratorHelper.getMethodName(it);
        _builder.append((Object)_methodName);
        _builder.append("(");
        String _simpleName = argumentType.getSimpleName();
        _builder.append(_simpleName);
        _builder.append(" obj) {");
        _builder.newLineIfNotEmpty();
        boolean _equals = Objects.equal(argumentType, FEnumerator.class);
        if (_equals) {
            _builder.append("\t");
            _builder.append("// check if this enumerator is overwritten");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (mappedEnumerators.containsKey(obj)) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("FDEnumValue fo = mappedEnumerators.get(obj);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _genOverwriteAccess = this.genOverwriteAccess(it, "fo");
            _builder.append((Object)_genOverwriteAccess, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        } else {
            boolean _equals_1 = Objects.equal(argumentType, FField.class);
            if (_equals_1) {
                _builder.append("\t");
                _builder.append("// check if this field is overwritten");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("if (mappedFields.containsKey(obj)) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("FDField fo = mappedFields.get(obj);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _genOverwriteAccess_1 = this.genOverwriteAccess(it, "fo");
                _builder.append((Object)_genOverwriteAccess_1, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            } else {
                boolean _equals_2 = Objects.equal(argumentType, EObject.class);
                if (_equals_2) {
                    _builder.append("\t");
                    _builder.append("if (obj instanceof FField) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("// check if this field is overwritten");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("if (mappedFields.containsKey(obj)) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("FDField fo = mappedFields.get(obj);");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    CharSequence _genOverwriteAccess_2 = this.genOverwriteAccess(it, "fo");
                    _builder.append((Object)_genOverwriteAccess_2, "\t\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("} else {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("if (overwrites!=null) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("// this is some model element which might be overwritten");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    CharSequence _genOverwriteAccess_3 = this.genOverwriteAccess(it, "obj");
                    _builder.append((Object)_genOverwriteAccess_3, "\t\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                } else {
                    _builder.append("\t");
                    _builder.append("if (overwrites!=null) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    CharSequence _genOverwriteAccess_4 = this.genOverwriteAccess(it, "overwrites");
                    _builder.append((Object)_genOverwriteAccess_4, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
            }
        }
        _builder.append("\t");
        _builder.append("return delegate.get");
        String _name = it.getName();
        _builder.append(_name, "\t");
        _builder.append("(obj);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence genOverwriteAccess(FDPropertyDecl it, String objname) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _javaType = this._importManager.getJavaType(it.getType());
        _builder.append((Object)_javaType);
        _builder.append(" v = target.get");
        String _getter = GeneratorHelper.getGetter(it.getType());
        _builder.append(_getter);
        _builder.append("(");
        _builder.append(objname);
        _builder.append(", ");
        String _extraArgs = GeneratorHelper.getExtraArgs(it.getType());
        _builder.append(_extraArgs);
        _builder.append("\"");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("if (v!=null)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return v;");
        _builder.newLine();
        return _builder;
    }

    @Override
    public CharSequence genEnumMethod(FDPropertyDecl it, Class<? extends EObject> argumentType, String enumType, String returnType, FDEnumType enumerator, boolean isData) {
        StringConcatenation _builder = new StringConcatenation();
        if (isData) {
            _builder.append("@Override");
            _builder.newLine();
        }
        _builder.append("public ");
        _builder.append(returnType);
        _builder.append(" ");
        CharSequence _methodName = GeneratorHelper.getMethodName(it);
        _builder.append((Object)_methodName);
        _builder.append("(");
        String _simpleName = argumentType.getSimpleName();
        _builder.append(_simpleName);
        _builder.append(" obj) {");
        _builder.newLineIfNotEmpty();
        boolean _equals = Objects.equal(argumentType, FEnumerator.class);
        if (_equals) {
            _builder.append("\t");
            _builder.append("// check if this enumerator is overwritten");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (mappedEnumerators.containsKey(obj)) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("FDEnumValue fo = mappedEnumerators.get(obj);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _genEnumOverwriteAccess = this.genEnumOverwriteAccess(it, enumType, "fo");
            _builder.append((Object)_genEnumOverwriteAccess, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        } else {
            boolean _equals_1 = Objects.equal(argumentType, FField.class);
            if (_equals_1) {
                _builder.append("\t");
                _builder.append("// check if this field is overwritten");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("if (mappedFields.containsKey(obj)) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("FDField fo = mappedFields.get(obj);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _genEnumOverwriteAccess_1 = this.genEnumOverwriteAccess(it, enumType, "fo");
                _builder.append((Object)_genEnumOverwriteAccess_1, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            } else {
                boolean _equals_2 = Objects.equal(argumentType, EObject.class);
                if (_equals_2) {
                    _builder.append("\t");
                    _builder.append("if (obj instanceof FField) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("// check if this field is overwritten");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("if (mappedFields.containsKey(obj)) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("FDField fo = mappedFields.get(obj);");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    CharSequence _genEnumOverwriteAccess_2 = this.genEnumOverwriteAccess(it, enumType, "fo");
                    _builder.append((Object)_genEnumOverwriteAccess_2, "\t\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("} else {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("if (overwrites!=null) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("// this is some model element which might be overwritten");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    CharSequence _genEnumOverwriteAccess_3 = this.genEnumOverwriteAccess(it, enumType, "obj");
                    _builder.append((Object)_genEnumOverwriteAccess_3, "\t\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                } else {
                    _builder.append("\t");
                    _builder.append("if (overwrites!=null) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    CharSequence _genEnumOverwriteAccess_4 = this.genEnumOverwriteAccess(it, enumType, "overwrites");
                    _builder.append((Object)_genEnumOverwriteAccess_4, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
            }
        }
        _builder.append("\t");
        _builder.append("return delegate.get");
        String _name = it.getName();
        _builder.append(_name, "\t");
        _builder.append("(obj);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence genEnumOverwriteAccess(FDPropertyDecl it, String enumType, String objname) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _javaType = this._importManager.getJavaType(it.getType());
        _builder.append((Object)_javaType);
        _builder.append(" e = target.get");
        String _getter = GeneratorHelper.getGetter(it.getType());
        _builder.append(_getter);
        _builder.append("(");
        _builder.append(objname);
        _builder.append(", \"");
        _builder.append(enumType);
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("if (e!=null) {");
        _builder.newLine();
        String _array = it.getType().getArray();
        boolean bl = _tripleNotEquals = _array != null;
        if (_tripleNotEquals) {
            _builder.append("\t");
            _builder.append("List<");
            _builder.append(enumType, "\t");
            _builder.append("> es = new ArrayList<");
            _builder.append(enumType, "\t");
            _builder.append(">();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("for(String ev : e) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append(enumType, "\t\t");
            _builder.append(" v = DataPropertyAccessorHelper.convert");
            String _name = it.getName();
            _builder.append(_name, "\t\t");
            _builder.append("(ev);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if (v!=null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("es.add(v);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return es;");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("return DataPropertyAccessorHelper.convert");
            String _name_1 = it.getName();
            _builder.append(_name_1, "\t");
            _builder.append("(e);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

