/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.generator.internal;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.deploymodel.core.FDPropertyHost;
import org.franca.deploymodel.core.FDeployedRootElement;
import org.franca.deploymodel.dsl.fDeploy.FDDeclaration;
import org.franca.deploymodel.dsl.fDeploy.FDEnumType;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;
import org.franca.deploymodel.dsl.fDeploy.FDType;
import org.franca.deploymodel.dsl.generator.internal.CodeContext;
import org.franca.deploymodel.dsl.generator.internal.CommonAccessorMethodGenerator;
import org.franca.deploymodel.dsl.generator.internal.GeneratorHelper;
import org.franca.deploymodel.dsl.generator.internal.HostLogic;
import org.franca.deploymodel.dsl.generator.internal.ICodeContext;
import org.franca.deploymodel.dsl.generator.internal.ImportManager;

public class RootElementAccessorGenerator {
    @Inject
    @Extension
    private ImportManager _importManager;
    @Inject
    private CommonAccessorMethodGenerator helper;

    public CharSequence generate(FDSpecification spec, Class<? extends EObject> rootClass, String prefix, String extensionName, Functions.Function1<? super FDPropertyHost, ? extends Boolean> checkHost) {
        boolean _isTargetNeeded_1;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _xblockexpression = null;
        CodeContext context = new CodeContext();
        String rootTag = StringExtensions.toFirstUpper((String)prefix);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("FDeployedRootElement<");
        String _simpleName = rootClass.getSimpleName();
        _builder.append(_simpleName);
        _builder.append(">");
        String deployed = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        EList<FDDeclaration> _declarations = spec.getDeclarations();
        for (FDDeclaration d : _declarations) {
            CharSequence _genProperties = this.genProperties(d, checkHost, context);
            _builder_1.append((Object)_genProperties);
            _builder_1.newLineIfNotEmpty();
        }
        String methods = _builder_1.toString();
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("/**");
        _builder_2.newLine();
        _builder_2.append(" ");
        _builder_2.append("* Accessor for deployment properties for '");
        _builder_2.append(prefix, " ");
        _builder_2.append("' roots");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append(" ");
        _builder_2.append("* (which are defined by the '");
        _builder_2.append(extensionName, " ");
        _builder_2.append("' extension)");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append(" ");
        _builder_2.append("* according to the '");
        String _name = spec.getName();
        _builder_2.append(_name, " ");
        _builder_2.append("' specification.");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append(" ");
        _builder_2.append("*/");
        _builder_2.newLine();
        _builder_2.append("public static class ");
        _builder_2.append(rootTag);
        _builder_2.append("PropertyAccessor");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("\t");
        FDSpecification _base = spec.getBase();
        boolean bl = _tripleNotEquals = _base != null;
        if (_tripleNotEquals) {
            _builder_2.append("extends ");
            String _qualifiedClassname = GeneratorHelper.getQualifiedClassname(spec.getBase());
            _builder_2.append(_qualifiedClassname, "\t");
            _builder_2.append(".");
            _builder_2.append(rootTag, "\t");
            _builder_2.append("PropertyAccessor");
        }
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("\t");
        _builder_2.append("implements Enums");
        _builder_2.newLine();
        _builder_2.append("{");
        _builder_2.newLine();
        boolean _isTargetNeeded = context.isTargetNeeded();
        if (_isTargetNeeded) {
            _builder_2.append("\t");
            _builder_2.append("final private ");
            _builder_2.append(deployed, "\t");
            _builder_2.append(" target;");
            _builder_2.newLineIfNotEmpty();
        }
        _builder_2.newLine();
        _builder_2.append("\t");
        this._importManager.addNeededOtherType(FDeployedRootElement.class);
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("\t");
        this._importManager.addNeededFrancaType(rootClass);
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("\t");
        _builder_2.append("public ");
        _builder_2.append(rootTag, "\t");
        _builder_2.append("PropertyAccessor(");
        _builder_2.append(deployed, "\t");
        _builder_2.append(" target) {");
        _builder_2.newLineIfNotEmpty();
        FDSpecification _base_1 = spec.getBase();
        boolean bl2 = _tripleNotEquals_1 = _base_1 != null;
        if (_tripleNotEquals_1) {
            _builder_2.append("\t\t");
            _builder_2.append("super(target);");
            _builder_2.newLine();
        }
        if (_isTargetNeeded_1 = context.isTargetNeeded()) {
            _builder_2.append("\t\t");
            _builder_2.append("this.target = target;");
            _builder_2.newLine();
        }
        _builder_2.append("\t");
        _builder_2.append("}");
        _builder_2.newLine();
        _builder_2.append("\t");
        _builder_2.newLine();
        _builder_2.append("\t");
        _builder_2.append(methods, "\t");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("}");
        _builder_2.newLine();
        _xblockexpression = _builder_2;
        return _xblockexpression;
    }

    private CharSequence genProperties(FDDeclaration decl, Functions.Function1<? super FDPropertyHost, ? extends Boolean> checkHost, ICodeContext context) {
        StringConcatenation _builder = new StringConcatenation();
        if (decl.getProperties().size() > 0 && ((Boolean)checkHost.apply((Object)decl.getHost())).booleanValue()) {
            _builder.append("// host '");
            String _name = decl.getHost().getName();
            _builder.append(_name);
            _builder.append("'");
            _builder.newLineIfNotEmpty();
            EList<FDPropertyDecl> _properties = decl.getProperties();
            for (FDPropertyDecl p : _properties) {
                CharSequence _genProperty = this.genProperty(p, decl.getHost(), context);
                _builder.append((Object)_genProperty);
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence genProperty(FDPropertyDecl it, FDPropertyHost host, ICodeContext context) {
        String _xblockexpression = null;
        Class<? extends EObject> argumentType = HostLogic.getArgumentType(host, HostLogic.Context.NON_FRANCA);
        CharSequence _xifexpression = null;
        if (argumentType != null) {
            CharSequence _xblockexpression_1 = null;
            this._importManager.addNeededFrancaType(argumentType);
            context.requireTargetMember();
            CharSequence _xifexpression_1 = null;
            boolean _isEnum = GeneratorHelper.isEnum(it);
            if (_isEnum) {
                CharSequence _xblockexpression_2 = null;
                String enumType = StringExtensions.toFirstUpper((String)it.getName());
                String _xifexpression_2 = null;
                String _array = it.getType().getArray();
                boolean _tripleEquals = _array == null;
                _xifexpression_2 = _tripleEquals ? enumType : this._importManager.genListType(enumType).toString();
                String retType = _xifexpression_2;
                FDType _complex = it.getType().getComplex();
                FDEnumType enumerator = (FDEnumType)_complex;
                _xifexpression_1 = _xblockexpression_2 = this.helper.generateEnumMethod(it, argumentType, enumType, retType, enumerator);
            } else {
                _xifexpression_1 = this.helper.generateMethod(it, argumentType);
            }
            _xblockexpression_1 = _xifexpression_1;
            _xifexpression = _xblockexpression_1;
        } else {
            _xifexpression = "";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

